/*
 * Decompiled with CFR 0.152.
 */
package nl.pdok.catalog;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import nl.pdok.catalog.exceptions.ConfigurationException;
import nl.pdok.catalog.extract.ExtractConfiguration;
import nl.pdok.catalog.featured.FeatureTemplate;
import nl.pdok.catalog.featured.FeaturedCollectionOptions;
import nl.pdok.catalog.job.JobConfigurationDataset;
import nl.pdok.catalog.testdata.TestData;
import nl.pdok.catalog.tiling.TilingConfiguration;
import nl.pdok.catalog.workbench.Workbench;
import nl.pdok.catalog.workbench.WorkbenchType;

public interface Catalog {
    public String getRootLocation();

    public boolean datasetExists(String var1);

    public String getDatasetNameVersioned(String var1, long var2);

    public boolean isVersioned(String var1);

    public Collection<String> getDatasetNames();

    public Path getDatasetLocationTest(String var1);

    public Path getDatasetLocationTestData(String var1);

    public List<TestData> getDatasetTestData(String var1);

    public Path getDatasetLocationTestExpected(String var1);

    public InputStream getResourcePrepareTestset(String var1, String var2) throws IOException;

    public Path getDatasetLocationTemplatesPath(String var1);

    public File getTemplateResource(String var1, String var2, String var3, String var4);

    public InputStream getDdlResource(String var1) throws IOException;

    public InputStream getSqlResource(String var1, String var2) throws IOException;

    public InputStream getCsvResource(String var1, String var2) throws IOException;

    public List<JobConfigurationDataset> getDatastoresConfiguration(String var1);

    public String getServiceName(String var1);

    public String getGeoserverType(String var1);

    public String getTargetProjection(String var1);

    public boolean withIndexes(String var1);

    public boolean withGtPkMetadata(String var1);

    public TilingConfiguration getTilingConfiguration(String var1);

    public ExtractConfiguration getExtractConfiguration(String var1);

    public Path getDatasetLocationShapesToDB(String var1);

    public Path getDatasetLocationShapesToFeatured(String var1);

    public ArrayList<FeaturedCollectionOptions> getFeatureOptions(String var1);

    public Set<FeatureTemplate> getFeatureTemplates(String var1) throws IOException;

    public String getXml2JsonMapping(String var1, String var2) throws IOException;

    public String getEngineTransformJson(String var1) throws ConfigurationException;

    public List<Workbench> getWorkbenches(String var1);

    public List<Workbench> getWorkbenches(String var1, WorkbenchType var2);

    public Workbench getWorkbench(String var1, WorkbenchType var2, String var3);

    public List<Workbench> getTransformers();
}

