/*
 * Decompiled with CFR 0.152.
 */
package nl._42.boot.docker.postgres;

import java.io.IOException;
import nl._42.boot.docker.postgres.AbstractDockerAvailableCheck;
import nl._42.boot.docker.postgres.DockerPostgresBootSequence;
import nl._42.boot.docker.postgres.DockerPostgresProperties;
import nl._42.boot.docker.postgres.ExpectedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerAvailableCheck
extends AbstractDockerAvailableCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerPostgresBootSequence.class);
    private static final String COMMAND = "docker ps";
    private final String containerName;
    private final String imageNameAndVersion;

    public DockerContainerAvailableCheck(DockerPostgresProperties properties) {
        super(COMMAND, properties);
        this.containerName = properties.getContainerName();
        this.imageNameAndVersion = properties.getImageName() + ":" + properties.getImageVersion();
    }

    public boolean hasContainer() throws IOException {
        if (this.hasValues(new ExpectedValue(1, this.imageNameAndVersion), new ExpectedValue(6, this.containerName))) {
            LOGGER.info("| Container [" + this.containerName + " for " + this.imageNameAndVersion + "] exists");
            return true;
        }
        LOGGER.info("| Container [" + this.containerName + " for " + this.imageNameAndVersion + "] not found; no force remove needed");
        return false;
    }
}

