/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.log.jcl;

import java.io.Serializable;
import net.ymate.platform.core.YMP;
import net.ymate.platform.core.util.RuntimeUtils;
import net.ymate.platform.log.AbstractLogger;
import net.ymate.platform.log.ILog;
import net.ymate.platform.log.ILogger;
import net.ymate.platform.log.LogInfo;
import net.ymate.platform.log.Logs;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.SimpleLog;

public class JCLogger
extends AbstractLogger
implements Log,
Serializable {
    private transient Log __simplog;
    private ILogger __logger;
    private String __loggerName;
    private boolean __inited;

    public JCLogger(String name) {
        this.__loggerName = name;
        this.__tryCheckAndInitLogImpl();
    }

    private Log __tryGetLogSafely() {
        if (this.__simplog == null) {
            this.__simplog = new SimpleLog(this.__loggerName);
        }
        return this.__simplog;
    }

    private boolean __tryCheckAndInitLogImpl() {
        if (YMP.get() == null || !YMP.get().isInited() || Logs.get() == null || !Logs.get().isInited()) {
            return false;
        }
        if (!this.__inited && YMP.get() != null && YMP.get().isInited() && Logs.get() != null && Logs.get().isInited()) {
            try {
                this.__logger = Logs.get().getLogger(this.__loggerName).depth(5);
                this.__inited = true;
            }
            catch (Exception e) {
                this.__tryGetLogSafely().warn((Object)"", RuntimeUtils.unwrapThrow((Throwable)e));
            }
        }
        return this.__inited;
    }

    protected void __doBuildEx(String info, Throwable e, ILogger.LogLevel level) {
        if (this.__tryCheckAndInitLogImpl()) {
            this.__logger.log(info, e, level);
        } else {
            this.__tryGetLogSafely();
            switch (level) {
                case TRACE: {
                    this.__simplog.trace((Object)info, e);
                    break;
                }
                case DEBUG: {
                    this.__simplog.debug((Object)info, e);
                    break;
                }
                case ALL: 
                case INFO: {
                    this.__simplog.info((Object)info, e);
                    break;
                }
                case WARN: {
                    this.__simplog.warn((Object)info, e);
                    break;
                }
                case ERROR: {
                    this.__simplog.error((Object)info, e);
                    break;
                }
                case FATAL: {
                    this.__simplog.fatal((Object)info, e);
                }
            }
        }
    }

    protected void __doLogWrite(ILogger.LogLevel level, LogInfo content) {
        throw new UnsupportedOperationException();
    }

    public void debug(Object message) {
        if (this.isDebugEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), null, ILogger.LogLevel.DEBUG);
        }
    }

    public void debug(Object message, Throwable t) {
        if (this.isDebugEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), t, ILogger.LogLevel.DEBUG);
        }
    }

    public void error(Object message) {
        if (this.isErrorEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), null, ILogger.LogLevel.ERROR);
        }
    }

    public void error(Object message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), t, ILogger.LogLevel.ERROR);
        }
    }

    public void fatal(Object message) {
        if (this.isFatalEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), null, ILogger.LogLevel.FATAL);
        }
    }

    public void fatal(Object message, Throwable t) {
        if (this.isFatalEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), t, ILogger.LogLevel.FATAL);
        }
    }

    public void info(Object message) {
        if (this.isInfoEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), null, ILogger.LogLevel.INFO);
        }
    }

    public void info(Object message, Throwable t) {
        if (this.isInfoEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), t, ILogger.LogLevel.INFO);
        }
    }

    public ILogger init(ILog owner, String loggerName) throws Exception {
        throw new UnsupportedOperationException();
    }

    public ILogger getLogger(String loggerName) throws Exception {
        throw new UnsupportedOperationException();
    }

    public Object getLoggerImpl() {
        throw new UnsupportedOperationException();
    }

    public String getLoggerName() {
        throw new UnsupportedOperationException();
    }

    public void destroy() {
    }

    public boolean contains(String loggerName) {
        throw new UnsupportedOperationException();
    }

    public ILogger.LogLevel getLevel() {
        throw new UnsupportedOperationException();
    }

    public void log(String info, ILogger.LogLevel level) {
        throw new UnsupportedOperationException();
    }

    public void log(Throwable e, ILogger.LogLevel level) {
        throw new UnsupportedOperationException();
    }

    public void log(String info, Throwable e, ILogger.LogLevel level) {
        throw new UnsupportedOperationException();
    }

    public void trace(String info) {
        throw new UnsupportedOperationException();
    }

    public void trace(Throwable e) {
        throw new UnsupportedOperationException();
    }

    public void trace(String info, Throwable e) {
        throw new UnsupportedOperationException();
    }

    public void debug(String info) {
        throw new UnsupportedOperationException();
    }

    public void debug(Throwable e) {
        throw new UnsupportedOperationException();
    }

    public void debug(String info, Throwable e) {
        throw new UnsupportedOperationException();
    }

    public void info(String info) {
        throw new UnsupportedOperationException();
    }

    public void info(Throwable e) {
        throw new UnsupportedOperationException();
    }

    public void info(String info, Throwable e) {
        throw new UnsupportedOperationException();
    }

    public void warn(String info) {
        throw new UnsupportedOperationException();
    }

    public void warn(Throwable e) {
        throw new UnsupportedOperationException();
    }

    public void warn(String info, Throwable e) {
        throw new UnsupportedOperationException();
    }

    public void error(String info) {
        throw new UnsupportedOperationException();
    }

    public void error(Throwable e) {
        throw new UnsupportedOperationException();
    }

    public void error(String info, Throwable e) {
        throw new UnsupportedOperationException();
    }

    public void fatal(String info) {
        throw new UnsupportedOperationException();
    }

    public void fatal(Throwable e) {
        throw new UnsupportedOperationException();
    }

    public void fatal(String info, Throwable e) {
        throw new UnsupportedOperationException();
    }

    public boolean isDebugEnabled() {
        if (this.__tryCheckAndInitLogImpl()) {
            return this.__logger.isDebugEnabled();
        }
        return this.__tryGetLogSafely().isDebugEnabled();
    }

    public boolean isErrorEnabled() {
        if (this.__tryCheckAndInitLogImpl()) {
            return this.__logger.isErrorEnabled();
        }
        return this.__tryGetLogSafely().isErrorEnabled();
    }

    public boolean isFatalEnabled() {
        if (this.__tryCheckAndInitLogImpl()) {
            return this.__logger.isFatalEnabled();
        }
        return this.__tryGetLogSafely().isFatalEnabled();
    }

    public boolean isInfoEnabled() {
        if (this.__tryCheckAndInitLogImpl()) {
            return this.__logger.isInfoEnabled();
        }
        return this.__tryGetLogSafely().isInfoEnabled();
    }

    public boolean isTraceEnabled() {
        if (this.__tryCheckAndInitLogImpl()) {
            return this.__logger.isTraceEnabled();
        }
        return this.__tryGetLogSafely().isTraceEnabled();
    }

    public boolean isWarnEnabled() {
        if (this.__tryCheckAndInitLogImpl()) {
            return this.__logger.isWarnEnabled();
        }
        return this.__tryGetLogSafely().isWarnEnabled();
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), null, ILogger.LogLevel.TRACE);
        }
    }

    public void trace(Object message, Throwable t) {
        if (this.isTraceEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), t, ILogger.LogLevel.TRACE);
        }
    }

    public void warn(Object message) {
        if (this.isWarnEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), null, ILogger.LogLevel.WARN);
        }
    }

    public void warn(Object message, Throwable t) {
        if (this.isWarnEnabled()) {
            this.__doBuildEx(message == null ? null : message.toString(), t, ILogger.LogLevel.WARN);
        }
    }
}

