/*
 * Decompiled with CFR 0.152.
 */
package net.ymate.platform.log.jcl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.ymate.platform.log.jcl.JCLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;

public class JCLogFactory
extends LogFactory {
    private static Map<String, Log> __LOGGER_CACHE = new ConcurrentHashMap<String, Log>();
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public Log getInstance(String name) throws LogConfigurationException {
        Log _logger = __LOGGER_CACHE.get(name);
        if (_logger == null) {
            _logger = new JCLogger(name);
            __LOGGER_CACHE.put(name, _logger);
        }
        return _logger;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public void release() {
        __LOGGER_CACHE.clear();
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }
}

