/*
 * Decompiled with CFR 0.152.
 */
package cascading.stats.tez;

import cascading.PlatformTestCase;
import cascading.cascade.Cascade;
import cascading.cascade.CascadeConnector;
import cascading.flow.Flow;
import cascading.operation.Filter;
import cascading.operation.Function;
import cascading.operation.regex.RegexParser;
import cascading.operation.state.Counter;
import cascading.pipe.Each;
import cascading.pipe.GroupBy;
import cascading.pipe.Pipe;
import cascading.tap.SinkMode;
import cascading.tap.Tap;
import cascading.tuple.Fields;
import data.InputData;
import org.junit.Test;

public class TezStatsPlatformTest
extends PlatformTestCase {
    public TezStatsPlatformTest() {
        super(true, 1, 4);
    }

    @Test
    public void testStatsCounters() throws Exception {
        this.getPlatform().copyFromLocal(InputData.inputFileApache);
        Tap source = this.getPlatform().getTextFile(InputData.inputFileApache);
        Pipe pipe = new Pipe("first");
        pipe = new Each(pipe, new Fields(new Comparable[]{"line"}), (Function)new RegexParser(new Fields(new Comparable[]{"ip"}), "^[^ ]*"), new Fields(new Comparable[]{"ip"}));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.FIRST));
        pipe = new GroupBy(pipe, new Fields(new Comparable[]{"ip"}));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.FIRST));
        pipe = new Each(pipe, (Filter)new Counter((Enum)TestEnum.SECOND));
        Tap sink1 = this.getPlatform().getTextFile(this.getOutputPath("flowstats1"), SinkMode.REPLACE);
        Tap sink2 = this.getPlatform().getTextFile(this.getOutputPath("flowstats2"), SinkMode.REPLACE);
        Flow flow1 = this.getPlatform().getFlowConnector().connect("stats1 test", source, sink1, pipe);
        Flow flow2 = this.getPlatform().getFlowConnector().connect("stats2 test", source, sink2, pipe);
        Cascade cascade = new CascadeConnector(this.getProperties()).connect(new Flow[]{flow1, flow2});
        cascade.complete();
    }

    static enum TestEnum {
        FIRST,
        SECOND,
        THIRD;

    }
}

