/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.translator.config;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import net.tokensmith.otter.translator.JsonTranslator;

public class TranslatorAppFactory {
    private static ObjectMapper objectMapper;
    private static ObjectReader objectReader;
    private static ObjectWriter objectWriter;

    public <T> JsonTranslator<T> jsonTranslator(Class<T> clazz) {
        return new JsonTranslator<T>(this.objectReader().forType(clazz), this.objectWriter(), clazz);
    }

    public ObjectReader objectReader() {
        if (objectReader == null) {
            objectReader = this.objectMapper().reader();
        }
        return objectReader;
    }

    public ObjectWriter objectWriter() {
        if (objectWriter == null) {
            objectWriter = this.objectMapper().writer();
        }
        return objectWriter;
    }

    public ObjectMapper objectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE).configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
        }
        return objectMapper;
    }
}

