/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.servlet.async;

import java.io.IOException;
import java.util.Queue;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteListenerImpl
implements WriteListener {
    protected static Logger LOGGER = LoggerFactory.getLogger(WriteListenerImpl.class);
    private ServletOutputStream output = null;
    private Queue queue = null;
    private AsyncContext context = null;

    public WriteListenerImpl(ServletOutputStream sos, Queue q, AsyncContext c) {
        this.output = sos;
        this.queue = q;
        this.context = c;
    }

    public void onWritePossible() throws IOException {
        while (this.queue.peek() != null && this.output.isReady()) {
            byte[] data = (byte[])this.queue.poll();
            this.output.write(data, 0, data.length);
        }
        if (this.queue.peek() == null) {
            this.context.complete();
        }
    }

    public void onError(Throwable t) {
        this.context.complete();
        LOGGER.error(t.getMessage(), t);
    }
}

