/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.servlet.async;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.tokensmith.otter.gateway.servlet.GatewayResponse;
import net.tokensmith.otter.gateway.servlet.ServletGateway;
import net.tokensmith.otter.servlet.async.WriteListenerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadListenerImpl
implements ReadListener {
    protected static Logger LOGGER = LoggerFactory.getLogger(ReadListenerImpl.class);
    private ServletGateway servletGateway;
    private ServletInputStream input = null;
    private AsyncContext ac = null;
    private Integer readChunkSize;
    private Queue<byte[]> queue = new LinkedBlockingQueue<byte[]>();

    public ReadListenerImpl(ServletGateway sg, ServletInputStream in, AsyncContext ac, Integer readChunkSize) {
        this.servletGateway = sg;
        this.input = in;
        this.ac = ac;
        this.readChunkSize = readChunkSize;
    }

    public void onDataAvailable() throws IOException {
        int len = -1;
        byte[] fixedBuffer = new byte[this.readChunkSize.intValue()];
        ByteArrayOutputStream variableBuffer = new ByteArrayOutputStream();
        while (this.input.isReady() && (len = this.input.read(fixedBuffer)) != -1 && !this.input.isFinished()) {
            int start = variableBuffer.size();
            variableBuffer.write(fixedBuffer, start, len);
        }
        this.queue.add(variableBuffer.toByteArray());
    }

    public void onAllDataRead() throws IOException {
        byte[] body;
        HttpServletResponse response;
        HttpServletRequest request = (HttpServletRequest)this.ac.getRequest();
        GatewayResponse gatewayResponse = this.servletGateway.processRequest(request, response = (HttpServletResponse)this.ac.getResponse(), body = this.queueToByteArray(this.queue));
        if (gatewayResponse.getPayload().isPresent()) {
            Queue out = this.byteArrayToQueue(gatewayResponse.getPayload().get(), gatewayResponse.getWriteChunkSize());
            ServletOutputStream output = response.getOutputStream();
            WriteListenerImpl writeListener = new WriteListenerImpl(output, out, this.ac);
            output.setWriteListener((WriteListener)writeListener);
        } else if (gatewayResponse.getTemplate().isPresent()) {
            this.ac.dispatch(request.getServletContext(), gatewayResponse.getTemplate().get());
        } else {
            this.ac.complete();
        }
    }

    public byte[] queueToByteArray(Queue<byte[]> queue) {
        ByteArrayOutputStream to = new ByteArrayOutputStream();
        while (queue.peek() != null) {
            try {
                to.write(queue.poll());
            }
            catch (IOException iOException) {}
        }
        return to.toByteArray();
    }

    public void onError(Throwable t) {
        LOGGER.error(t.getMessage(), t);
        this.ac.complete();
    }

    public Queue byteArrayToQueue(byte[] source, int chunksize) {
        LinkedBlockingQueue<byte[]> out = new LinkedBlockingQueue<byte[]>();
        for (int start = 0; start < source.length; start += chunksize) {
            int end = Math.min(source.length, start + chunksize);
            out.add(Arrays.copyOfRange(source, start, end));
        }
        return out;
    }
}

