/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.servlet.async;

import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.server.AsyncContextEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OtterAsyncListener
implements AsyncListener {
    protected static Logger LOGGER = LoggerFactory.getLogger(OtterAsyncListener.class);

    public void onComplete(AsyncEvent event) {
        AsyncContextEvent ace = (AsyncContextEvent)event;
        HttpServletRequest hsr = (HttpServletRequest)ace.getAsyncContext().getRequest();
        LOGGER.debug("Async Done: " + hsr.getMethod() + " " + ace.getPath());
    }

    public void onError(AsyncEvent event) {
        Throwable t = event.getThrowable();
        AsyncContextEvent ace = (AsyncContextEvent)event;
        HttpServletRequest hsr = (HttpServletRequest)ace.getAsyncContext().getRequest();
        String msg = "ErrorPayload: " + hsr.getMethod() + " " + ace.getPath() + " " + t.getMessage();
        LOGGER.error(msg, t);
    }

    public void onStartAsync(AsyncEvent event) {
        AsyncContextEvent ace = (AsyncContextEvent)event;
        HttpServletRequest hsr = (HttpServletRequest)ace.getAsyncContext().getRequest();
        LOGGER.debug("Async Started: " + hsr.getMethod() + " " + ace.getPath());
    }

    public void onTimeout(AsyncEvent event) {
        AsyncContextEvent ace = (AsyncContextEvent)event;
        HttpServletRequest hsr = (HttpServletRequest)ace.getAsyncContext().getRequest();
        LOGGER.error("Async timeout: " + hsr.getMethod() + " " + ace.getPath());
    }
}

