/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.servlet;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncListener;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.tokensmith.otter.config.OtterAppFactory;
import net.tokensmith.otter.controller.entity.DefaultSession;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.gateway.Configure;
import net.tokensmith.otter.gateway.entity.Group;
import net.tokensmith.otter.gateway.entity.Shape;
import net.tokensmith.otter.gateway.entity.rest.RestGroup;
import net.tokensmith.otter.gateway.servlet.ServletGateway;
import net.tokensmith.otter.security.exception.SessionCtorException;
import net.tokensmith.otter.servlet.async.OtterAsyncListener;
import net.tokensmith.otter.servlet.async.ReadListenerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OtterEntryServlet
extends HttpServlet {
    public static final String DESTROYING_SERVLET = "destroying servlet";
    public static final String INIT_AGAIN = "Servlet initializing after being destroyed. Not initializing Otter again.";
    public static final String INIT_OTTER = "Initializing Otter - Starting";
    public static final String INIT_OTTER_DONE = "Initializing Otter - Done - %s ms";
    protected static Logger LOGGER = LoggerFactory.getLogger(OtterEntryServlet.class);
    protected static OtterAppFactory otterAppFactory;
    protected static ServletGateway servletGateway;
    protected static Integer DEFAULT_READ_CHUNK_SIZE;
    protected static Integer readChunkSize;

    public void init() throws ServletException {
        Long start = Instant.now().toEpochMilli();
        if (this.hasBeenDestroyed().booleanValue()) {
            LOGGER.info(INIT_AGAIN);
        } else {
            LOGGER.info(INIT_OTTER);
            this.initOtter();
        }
        Long end = Instant.now().toEpochMilli();
        LOGGER.info(String.format(INIT_OTTER_DONE, end - start));
    }

    public void initOtter() throws ServletException {
        otterAppFactory = new OtterAppFactory();
        Configure configure = this.makeConfigure();
        Shape shape = configure.shape();
        List<Group<? extends DefaultSession, ? extends DefaultUser>> groups = configure.groups();
        List<RestGroup<? extends DefaultUser>> restGroups = configure.restGroups();
        try {
            servletGateway = otterAppFactory.servletGateway(shape, groups, restGroups);
        }
        catch (SessionCtorException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        configure.routes(servletGateway);
        readChunkSize = shape.getReadChunkSize() != null ? shape.getReadChunkSize() : DEFAULT_READ_CHUNK_SIZE;
    }

    protected Boolean hasBeenDestroyed() {
        Boolean hasBeenDestroyed = false;
        if (otterAppFactory != null || servletGateway != null) {
            hasBeenDestroyed = true;
        }
        return hasBeenDestroyed;
    }

    public abstract Configure makeConfigure();

    public void doAsync(HttpServletRequest request, HttpServletResponse response) throws IOException {
        AsyncContext context = request.startAsync((ServletRequest)request, (ServletResponse)response);
        OtterAsyncListener asyncListener = new OtterAsyncListener();
        context.addListener((AsyncListener)asyncListener);
        ServletInputStream input = request.getInputStream();
        ReadListenerImpl readListener = new ReadListenerImpl(servletGateway, input, context, readChunkSize);
        input.setReadListener((ReadListener)readListener);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doAsync(req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doAsync(req, resp);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doAsync(req, resp);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doAsync(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doAsync(req, resp);
    }

    public void destroy() {
        LOGGER.info(DESTROYING_SERVLET);
        super.destroy();
    }

    static {
        DEFAULT_READ_CHUNK_SIZE = 1024;
    }
}

