/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.servlet;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;

@WebFilter(filterName="EntryFilter", asyncSupported=true, urlPatterns={"/*"})
public class EntryFilter
implements Filter {
    protected static Pattern STATIC_ASSETS_PATTERN = Pattern.compile("(.*).(js|css)");
    protected static String OTTER_PREFIX = "/app";
    protected static String FORWARD_URI = OTTER_PREFIX + "%s";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String context = req.getRequestURI();
        Matcher staticAssetsMatcher = STATIC_ASSETS_PATTERN.matcher(context);
        if (staticAssetsMatcher.matches()) {
            chain.doFilter(request, response);
        } else {
            request.getRequestDispatcher(String.format(FORWARD_URI, context)).forward(request, response);
        }
    }

    public void destroy() {
    }
}

