/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.server.path;

import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAppPath {
    protected static Logger LOGGER = LoggerFactory.getLogger(WebAppPath.class);
    private static String FILE = "file:";
    private static String DEFAULT_WEB_APP = "/src/main/webapp";
    private static String GRADLE_PATH = "/build";
    private static String INTELLIJ_PATH = "/out";
    private static String MVN_PATH = "/target";

    public URI fromClassURI(URI classURI) throws URISyntaxException {
        return this.fromClassURI(classURI, DEFAULT_WEB_APP);
    }

    public URI fromClassURI(URI classURI, String customWebAppLocation) throws URISyntaxException {
        String projectPath = classURI.getPath().contains(MVN_PATH) ? this.makeProjectPath(classURI.getPath(), MVN_PATH) : (classURI.getPath().contains(GRADLE_PATH) ? this.makeProjectPath(classURI.getPath(), GRADLE_PATH) : this.makeProjectPath(classURI.getPath(), INTELLIJ_PATH));
        String webAppPath = FILE + projectPath + customWebAppLocation;
        URI webAppURI = new URI(webAppPath);
        return webAppURI;
    }

    protected String makeProjectPath(String classURI, String splitter) {
        StringBuilder projectPath = new StringBuilder();
        String[] parts = classURI.split(splitter);
        for (int i = 0; i < parts.length - 1; ++i) {
            projectPath.append(parts[i]);
            if (i >= parts.length - 2) continue;
            projectPath.append(splitter);
        }
        return projectPath.toString();
    }
}

