/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.server.container;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import net.tokensmith.otter.server.container.ServletContainer;
import net.tokensmith.otter.server.container.ServletContainerImpl;
import net.tokensmith.otter.server.container.builder.WebAppContextBuilder;
import net.tokensmith.otter.server.path.CompiledClassPath;
import net.tokensmith.otter.server.path.WebAppPath;
import net.tokensmith.otter.servlet.EntryFilter;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContainerFactory {
    protected static Logger logger = LoggerFactory.getLogger(ServletContainerFactory.class);
    private static String DIR_ALLOWED_KEY = "org.eclipse.jetty.servlet.Default.dirAllowed";
    private static String INCLUDE_JAR_PATTERN = "org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern";
    private static String JARS_TO_INCLUDE = ".*/[^/]*servlet-api-[^/]*\\.jar$|.*/javax.servlet.jsp.jstl-.*\\.jar$|.*/[^/]*taglibs.*\\.jar$";
    private static String JSP_SERVLET = "org.eclipse.jetty.jsp.JettyJspServlet";
    private static String FALSE = "false";
    private CompiledClassPath compiledClassPath;
    private WebAppPath webAppPath;

    public ServletContainerFactory(CompiledClassPath compiledClassPath, WebAppPath webAppPath) {
        this.compiledClassPath = compiledClassPath;
        this.webAppPath = webAppPath;
    }

    public ServletContainer makeServletContainer(String documentRoot, Class clazz, int port, String requestLog, List<String> gzipMimeTypes, List<ErrorPage> errorPages) throws URISyntaxException, IOException {
        URI compliedClassPath = this.compiledClassPath.getForClass(clazz);
        URI webApp = this.webAppPath.fromClassURI(compliedClassPath);
        return this.makeServletContainer(documentRoot, webApp, compliedClassPath, port, requestLog, gzipMimeTypes, errorPages);
    }

    public ServletContainer makeServletContainer(String documentRoot, URI webApp, URI compliedClassPath, int port, String requestLog, List<String> gzipMimeTypes, List<ErrorPage> errorPages) throws IOException {
        WebAppContext context;
        logger.debug("Web App location: " + webApp.toURL());
        logger.debug("Compiled Class path: " + compliedClassPath.toURL());
        Server jetty = new Server(port);
        Configuration[] configurations = this.makeConfigurations();
        PathResource containerResources = this.makeFileResource(compliedClassPath);
        String resourceBase = this.makeResourceBase(webApp);
        if (compliedClassPath.toURL().getFile().endsWith("war")) {
            logger.debug("Using a war file");
            context = this.makeWebAppContextForWAR(documentRoot, configurations, (Resource)containerResources, gzipMimeTypes, errorPages);
        } else {
            logger.debug("Not a war file");
            context = this.makeWebAppContext(documentRoot, resourceBase, configurations, containerResources, gzipMimeTypes, errorPages);
        }
        jetty.setHandler((Handler)context);
        ServerConnector serverConnector = this.makeServerConnector(jetty, port);
        jetty.setConnectors(new Connector[]{serverConnector});
        CustomRequestLog log = this.makeRequestLog(requestLog);
        jetty.setRequestLog((RequestLog)log);
        ServletContainerImpl server = new ServletContainerImpl(jetty);
        return server;
    }

    protected WebAppContext makeWebAppContext(String documentRoot, String resourceBase, Configuration[] configurations, PathResource containerResources, List<String> gzipMimeTypes, List<ErrorPage> errorPages) {
        WebAppContext webAppContext = new WebAppContextBuilder().classLoader(Thread.currentThread().getContextClassLoader()).resourceBase(resourceBase).configurations(configurations).containerResource(containerResources).initParameter(DIR_ALLOWED_KEY, FALSE).parentLoaderPriority(true).attribute(INCLUDE_JAR_PATTERN, JARS_TO_INCLUDE).jspServlet(JSP_SERVLET).gzipMimeTypes(gzipMimeTypes).errorPages(errorPages).stateless().staticAssetServlet(resourceBase + "/public/").build();
        webAppContext.addFilter(EntryFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        return webAppContext;
    }

    protected WebAppContext makeWebAppContextForWAR(String documentRoot, Configuration[] configurations, Resource war, List<String> gzipMimeTypes, List<ErrorPage> errorPages) {
        logger.debug("war: " + war.getURI().toString());
        WebAppContext webAppContext = new WebAppContextBuilder().classLoader(Thread.currentThread().getContextClassLoader()).configurations(configurations).initParameter(DIR_ALLOWED_KEY, FALSE).parentLoaderPriority(true).attribute(INCLUDE_JAR_PATTERN, JARS_TO_INCLUDE).jspServlet(JSP_SERVLET).gzipMimeTypes(gzipMimeTypes).errorPages(errorPages).stateless().staticAssetServletWar("/public/").build();
        webAppContext.addFilter(EntryFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        webAppContext.setExtractWAR(true);
        webAppContext.setWarResource(war);
        return webAppContext;
    }

    protected String makeResourceBase(URI webApp) throws MalformedURLException {
        Resource resourceBase = Resource.newResource((URI)webApp);
        return String.valueOf(resourceBase);
    }

    protected PathResource makeFileResource(URI classPath) throws IOException {
        return new PathResource(classPath);
    }

    protected Configuration[] makeConfigurations() {
        return new Configuration[]{new WebInfConfiguration(), new WebXmlConfiguration(), new AnnotationConfiguration()};
    }

    protected ServerConnector makeServerConnector(Server server, int port) {
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSendServerVersion(false);
        httpConfig.setSendDateHeader(true);
        HttpConnectionFactory httpFactory = new HttpConnectionFactory(httpConfig);
        HTTP2CServerConnectionFactory http2Factory = new HTTP2CServerConnectionFactory(httpConfig);
        ServerConnector serverConnector = new ServerConnector(server, new ConnectionFactory[]{httpFactory, http2Factory});
        serverConnector.setPort(port);
        return serverConnector;
    }

    protected CustomRequestLog makeRequestLog(String logFile) {
        CustomRequestLog requestLog = new CustomRequestLog(logFile);
        return requestLog;
    }
}

