/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.server;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import net.tokensmith.otter.config.OtterAppFactory;
import net.tokensmith.otter.server.HttpServerConfig;
import net.tokensmith.otter.server.container.ServletContainer;
import net.tokensmith.otter.server.container.ServletContainerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServer {
    private static final Logger logger = LoggerFactory.getLogger(HttpServer.class);
    private static ServletContainer server;

    public static void run(HttpServerConfig config) {
        server = HttpServer.makeServer(config);
        try {
            logger.info("server starting");
            server.start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        try {
            server.join();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static ServletContainer makeServer(HttpServerConfig config) {
        OtterAppFactory otterAppFactory = new OtterAppFactory();
        ServletContainerFactory servletContainerFactory = otterAppFactory.servletContainerFactory();
        ServletContainer server = null;
        try {
            server = servletContainerFactory.makeServletContainer(config.getDocumentRoot(), config.getClazz(), config.getPort(), config.getRequestLog(), config.getGzipMimeTypes(), config.getErrorPages());
        }
        catch (URISyntaxException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return server;
    }

    public static ServletContainer getServer() {
        return server;
    }
}

