/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.security.session.between;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.ByteArrayOutputStream;
import net.tokensmith.jwt.builder.compact.EncryptedCompactBuilder;
import net.tokensmith.jwt.builder.exception.CompactException;
import net.tokensmith.jwt.entity.jwe.EncryptionAlgorithm;
import net.tokensmith.jwt.entity.jwk.SymmetricKey;
import net.tokensmith.jwt.entity.jwt.header.Algorithm;
import net.tokensmith.otter.config.CookieConfig;
import net.tokensmith.otter.controller.entity.Cookie;
import net.tokensmith.otter.controller.entity.StatusCode;
import net.tokensmith.otter.controller.entity.request.Request;
import net.tokensmith.otter.controller.entity.response.Response;
import net.tokensmith.otter.router.entity.Method;
import net.tokensmith.otter.router.entity.between.Between;
import net.tokensmith.otter.router.exception.HaltException;
import net.tokensmith.otter.security.session.between.exception.EncryptSessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptSession<S, U>
implements Between<S, U> {
    public static final String NOT_ENCRYPTING = "Not re-encrypting session cookie";
    public static final String COULD_NOT_ENCRYPT_SESSION = "Could not encrypt session cookie";
    protected static Logger LOGGER = LoggerFactory.getLogger(EncryptSession.class);
    private CookieConfig cookieConfig;
    private SymmetricKey preferredKey;
    private ObjectWriter objectWriter;

    public EncryptSession(CookieConfig cookieConfig, SymmetricKey preferredKey, ObjectWriter objectWriter) {
        this.cookieConfig = cookieConfig;
        this.preferredKey = preferredKey;
        this.objectWriter = objectWriter;
    }

    @Override
    public void process(Method method, Request<S, U> request, Response<S> response) throws HaltException {
        if (this.shouldEncrypt(request, response).booleanValue()) {
            ByteArrayOutputStream session;
            try {
                session = this.encrypt(response.getSession().get());
            }
            catch (EncryptSessionException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                HaltException haltException = new HaltException(COULD_NOT_ENCRYPT_SESSION, e);
                this.onHalt(haltException, response);
                throw new HaltException(COULD_NOT_ENCRYPT_SESSION, e);
            }
            Cookie cookie = new Cookie();
            cookie.setName(this.cookieConfig.getName());
            cookie.setMaxAge(this.cookieConfig.getAge());
            cookie.setSecure(this.cookieConfig.getSecure());
            cookie.setHttpOnly(this.cookieConfig.getHttpOnly());
            cookie.setValue(session.toString());
            response.getCookies().put(this.cookieConfig.getName(), cookie);
        } else {
            LOGGER.debug(NOT_ENCRYPTING);
        }
    }

    protected void onHalt(HaltException e, Response response) {
        response.setStatusCode(StatusCode.SERVER_ERROR);
    }

    protected Boolean shouldEncrypt(Request<S, U> request, Response<S> response) {
        if (request.getSession().isPresent() && response.getSession().isPresent()) {
            if (response.getSession().get().equals(request.getSession().get())) {
                return false;
            }
            return true;
        }
        if (response.getSession().isPresent()) {
            return true;
        }
        return false;
    }

    protected ByteArrayOutputStream encrypt(S session) throws EncryptSessionException {
        ByteArrayOutputStream compactJwe;
        byte[] payload;
        try {
            payload = this.objectWriter.writeValueAsBytes(session);
        }
        catch (JsonProcessingException e) {
            throw new EncryptSessionException(e.getMessage(), e);
        }
        EncryptedCompactBuilder compactBuilder = new EncryptedCompactBuilder();
        try {
            compactJwe = compactBuilder.encAlg(EncryptionAlgorithm.AES_GCM_256).alg(Algorithm.DIRECT).payload(payload).cek(this.preferredKey).build();
        }
        catch (CompactException e) {
            throw new EncryptSessionException(e.getMessage(), e);
        }
        return compactJwe;
    }

    public CookieConfig getCookieConfig() {
        return this.cookieConfig;
    }

    public void setCookieConfig(CookieConfig cookieConfig) {
        this.cookieConfig = cookieConfig;
    }

    public SymmetricKey getPreferredKey() {
        return this.preferredKey;
    }

    public void setPreferredKey(SymmetricKey preferredKey) {
        this.preferredKey = preferredKey;
    }
}

