/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.security.session.between;

import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import net.tokensmith.jwt.config.JwtAppFactory;
import net.tokensmith.jwt.entity.jwk.Key;
import net.tokensmith.jwt.entity.jwk.SymmetricKey;
import net.tokensmith.jwt.entity.jwt.header.Header;
import net.tokensmith.jwt.exception.InvalidJWT;
import net.tokensmith.jwt.jwe.entity.JWE;
import net.tokensmith.jwt.jwe.factory.exception.CipherException;
import net.tokensmith.jwt.jwe.serialization.direct.JweDirectDesializer;
import net.tokensmith.jwt.jwe.serialization.exception.KeyException;
import net.tokensmith.jwt.serialization.HeaderDeserializer;
import net.tokensmith.jwt.serialization.exception.DecryptException;
import net.tokensmith.jwt.serialization.exception.JsonToJwtException;
import net.tokensmith.otter.controller.entity.Cookie;
import net.tokensmith.otter.controller.entity.StatusCode;
import net.tokensmith.otter.controller.entity.request.Request;
import net.tokensmith.otter.controller.entity.response.Response;
import net.tokensmith.otter.router.entity.Method;
import net.tokensmith.otter.router.entity.between.Between;
import net.tokensmith.otter.router.exception.HaltException;
import net.tokensmith.otter.security.exception.SessionCtorException;
import net.tokensmith.otter.security.session.between.exception.InvalidSessionException;
import net.tokensmith.otter.security.session.between.exception.SessionDecryptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptSession<S, U>
implements Between<S, U> {
    public static final String NOT_A_JWT = "Session cookie was not a JWE: %s";
    public static final String COULD_NOT_GET_HEADER_JWE = "Session cookie did have a header member: %s";
    public static final String COULD_NOT_DESERIALIZE_JWE = "Session cookie could not be de-serialized to JSON: %s";
    public static final String COULD_NOT_DECRYPT_JWE = "Session cookie could not be decrypted: %s";
    public static final String COULD_NOT_DESERIALIZE = "decrypted payload could be deserialized to session: %s";
    public static final String INVALID_SESSION_COOKIE = "Invalid value for the session cookie";
    public static final String COOKIE_NOT_PRESENT = "session cookie not present.";
    public static final String FAILED_TO_COPY_REQUEST_SESSION = "failed to copy request session";
    public static final String COULD_NOT_CALL_THE_SESSION_COPY_CONSTRUCTOR = "Could not call the session's copy constructor";
    protected static Logger LOGGER = LoggerFactory.getLogger(DecryptSession.class);
    private Constructor<S> ctor;
    private String sessionCookieName;
    private JwtAppFactory jwtAppFactory;
    private SymmetricKey preferredKey;
    private Map<String, SymmetricKey> rotationKeys;
    private ObjectReader objectReader;
    private Boolean required;

    public DecryptSession(Constructor<S> ctor, String sessionCookieName, JwtAppFactory jwtAppFactory, SymmetricKey preferredKey, Map<String, SymmetricKey> rotationKeys, ObjectReader objectReader, Boolean required) {
        this.ctor = ctor;
        this.sessionCookieName = sessionCookieName;
        this.jwtAppFactory = jwtAppFactory;
        this.preferredKey = preferredKey;
        this.rotationKeys = rotationKeys;
        this.objectReader = objectReader;
        this.required = required;
    }

    @Override
    public void process(Method method, Request<S, U> request, Response<S> response) throws HaltException {
        S responseSession;
        Optional<S> session;
        Cookie sessionCookie = request.getCookies().get(this.sessionCookieName);
        if (sessionCookie == null && this.required.booleanValue()) {
            HaltException halt = new HaltException(COOKIE_NOT_PRESENT);
            this.onHalt(halt, response);
            throw halt;
        }
        if (sessionCookie == null && !this.required.booleanValue()) {
            request.setSession(Optional.empty());
            return;
        }
        try {
            session = Optional.of(this.decrypt(sessionCookie.getValue()));
        }
        catch (InvalidSessionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            HaltException halt = new HaltException(INVALID_SESSION_COOKIE, e);
            this.onHalt(halt, response);
            throw halt;
        }
        catch (SessionDecryptException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            HaltException halt = new HaltException(INVALID_SESSION_COOKIE, e);
            this.onHalt(halt, response);
            throw halt;
        }
        request.setSession(session);
        try {
            responseSession = this.copy(session.get());
        }
        catch (SessionCtorException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            HaltException halt = new HaltException(FAILED_TO_COPY_REQUEST_SESSION, e);
            this.onHalt(halt, response);
            throw halt;
        }
        response.setSession(Optional.of(responseSession));
    }

    protected S copy(S from) throws SessionCtorException {
        S copy;
        try {
            copy = this.ctor.newInstance(from);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new SessionCtorException(COULD_NOT_CALL_THE_SESSION_COPY_CONSTRUCTOR, e);
        }
        return copy;
    }

    protected void onHalt(HaltException e, Response response) {
        response.setStatusCode(StatusCode.UNAUTHORIZED);
        response.getCookies().remove(this.sessionCookieName);
    }

    protected S decrypt(String encryptedSession) throws InvalidSessionException, SessionDecryptException {
        JWE sessionPayload;
        Header sessionHeader;
        HeaderDeserializer headerDeserializer = this.jwtAppFactory.headerDeserializer();
        try {
            sessionHeader = headerDeserializer.toHeader(encryptedSession);
        }
        catch (JsonToJwtException e) {
            String msg = String.format(NOT_A_JWT, encryptedSession);
            throw new InvalidSessionException(msg, e);
        }
        catch (InvalidJWT e) {
            String msg = String.format(COULD_NOT_GET_HEADER_JWE, encryptedSession);
            throw new InvalidSessionException(msg, e);
        }
        SymmetricKey key = this.getKey((String)sessionHeader.getKeyId().get());
        JweDirectDesializer deserializer = this.jwtAppFactory.jweDirectDesializer();
        try {
            sessionPayload = deserializer.stringToJWE(encryptedSession, (Key)key);
        }
        catch (JsonToJwtException e) {
            String msg = String.format(COULD_NOT_DESERIALIZE_JWE, encryptedSession);
            throw new InvalidSessionException(msg, e);
        }
        catch (CipherException | KeyException | DecryptException e) {
            String msg = String.format(COULD_NOT_DECRYPT_JWE, encryptedSession);
            throw new SessionDecryptException(msg, e);
        }
        return this.toSession(sessionPayload.getPayload());
    }

    protected S toSession(byte[] json) {
        Object session = null;
        try {
            session = this.objectReader.readValue(json);
        }
        catch (IOException e) {
            String msg = String.format(COULD_NOT_DESERIALIZE, new String(json, StandardCharsets.UTF_8));
            LOGGER.error(msg);
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return (S)session;
    }

    protected SymmetricKey getKey(String keyId) {
        SymmetricKey key = ((String)this.preferredKey.getKeyId().get()).equals(keyId) ? this.preferredKey : this.rotationKeys.get(keyId);
        return key;
    }

    protected void setPreferredKey(SymmetricKey preferredKey) {
        this.preferredKey = preferredKey;
    }

    public Boolean getRequired() {
        return this.required;
    }
}

