/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.security.csrf.between;

import java.io.ByteArrayOutputStream;
import java.util.Optional;
import net.tokensmith.jwt.entity.jwt.JsonWebToken;
import net.tokensmith.otter.config.CookieConfig;
import net.tokensmith.otter.controller.entity.Cookie;
import net.tokensmith.otter.controller.entity.request.Request;
import net.tokensmith.otter.controller.entity.response.Response;
import net.tokensmith.otter.router.entity.Method;
import net.tokensmith.otter.router.entity.between.Between;
import net.tokensmith.otter.router.exception.HaltException;
import net.tokensmith.otter.security.csrf.CsrfClaims;
import net.tokensmith.otter.security.csrf.DoubleSubmitCSRF;
import net.tokensmith.otter.security.csrf.exception.CsrfException;
import net.tokensmith.otter.security.entity.ChallengeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareCSRF<S, U>
implements Between<S, U> {
    protected static Logger LOGGER = LoggerFactory.getLogger(PrepareCSRF.class);
    private CookieConfig cookieConfig;
    private DoubleSubmitCSRF doubleSubmitCSRF;

    public PrepareCSRF(DoubleSubmitCSRF doubleSubmitCSRF) {
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }

    public PrepareCSRF(CookieConfig cookieConfig, DoubleSubmitCSRF doubleSubmitCSRF) {
        this.cookieConfig = cookieConfig;
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }

    @Override
    public void process(Method method, Request<S, U> request, Response<S> response) throws HaltException {
        if (response.getCookies().get(this.cookieConfig.getName()) == null) {
            String challengeToken = this.doubleSubmitCSRF.makeChallengeToken();
            String cookieNoise = this.doubleSubmitCSRF.makeChallengeToken();
            String formNoise = this.doubleSubmitCSRF.makeChallengeToken();
            ChallengeToken cookieChallengeToken = new ChallengeToken(challengeToken, cookieNoise);
            ChallengeToken formChallengeToken = new ChallengeToken(challengeToken, formNoise);
            try {
                Cookie csrfCookie = this.doubleSubmitCSRF.makeCsrfCookie(this.cookieConfig.getName(), cookieChallengeToken, this.cookieConfig.getSecure(), this.cookieConfig.getAge(), this.cookieConfig.getHttpOnly());
                response.getCookies().put(this.cookieConfig.getName(), csrfCookie);
                ByteArrayOutputStream formValue = this.doubleSubmitCSRF.toJwt(formChallengeToken);
                request.setCsrfChallenge(Optional.of(formValue.toString()));
            }
            catch (CsrfException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        } else {
            JsonWebToken csrfJwt = null;
            try {
                csrfJwt = this.doubleSubmitCSRF.csrfToJwt(response.getCookies().get(this.cookieConfig.getName()).getValue());
            }
            catch (CsrfException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            String formNoise = this.doubleSubmitCSRF.makeChallengeToken();
            CsrfClaims claims = (CsrfClaims)csrfJwt.getClaims();
            ChallengeToken formChallengeToken = new ChallengeToken(claims.getChallengeToken(), formNoise);
            ByteArrayOutputStream formValue = null;
            try {
                formValue = this.doubleSubmitCSRF.toJwt(formChallengeToken);
            }
            catch (CsrfException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            request.setCsrfChallenge(Optional.of(formValue.toString()));
        }
    }

    public CookieConfig getCookieConfig() {
        return this.cookieConfig;
    }

    public void setCookieConfig(CookieConfig cookieConfig) {
        this.cookieConfig = cookieConfig;
    }

    public DoubleSubmitCSRF getDoubleSubmitCSRF() {
        return this.doubleSubmitCSRF;
    }

    public void setDoubleSubmitCSRF(DoubleSubmitCSRF doubleSubmitCSRF) {
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }
}

