/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.security.csrf.between;

import java.util.List;
import java.util.Optional;
import net.tokensmith.otter.controller.entity.Cookie;
import net.tokensmith.otter.controller.entity.StatusCode;
import net.tokensmith.otter.controller.entity.request.Request;
import net.tokensmith.otter.controller.entity.response.Response;
import net.tokensmith.otter.router.entity.Method;
import net.tokensmith.otter.router.entity.between.Between;
import net.tokensmith.otter.router.exception.CsrfException;
import net.tokensmith.otter.router.exception.HaltException;
import net.tokensmith.otter.security.csrf.DoubleSubmitCSRF;

public class CheckCSRF<S, U>
implements Between<S, U> {
    private String cookieName;
    private String formFieldName;
    private DoubleSubmitCSRF doubleSubmitCSRF;
    private static String HALT_MSG = "CSRF failed.";

    public CheckCSRF(DoubleSubmitCSRF doubleSubmitCSRF) {
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }

    public CheckCSRF(String cookieName, String formFieldName, DoubleSubmitCSRF doubleSubmitCSRF) {
        this.cookieName = cookieName;
        this.formFieldName = formFieldName;
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }

    @Override
    public void process(Method method, Request<S, U> request, Response<S> response) throws HaltException {
        Cookie csrfCookie = request.getCookies().get(this.cookieName);
        List<String> formValue = request.getFormData().get(this.formFieldName);
        Boolean ok = csrfCookie != null && formValue != null && formValue.size() == 1 ? this.doubleSubmitCSRF.doTokensMatch(csrfCookie.getValue(), formValue.get(0)) : Boolean.valueOf(false);
        if (!ok.booleanValue()) {
            CsrfException haltException = new CsrfException(HALT_MSG);
            this.onHalt(haltException, response);
            throw haltException;
        }
        request.setCsrfChallenge(Optional.of(formValue.get(0)));
    }

    protected void onHalt(HaltException e, Response response) {
        response.setStatusCode(StatusCode.FORBIDDEN);
    }

    public String getCookieName() {
        return this.cookieName;
    }

    public void setCookieName(String cookieName) {
        this.cookieName = cookieName;
    }

    public String getFormFieldName() {
        return this.formFieldName;
    }

    public void setFormFieldName(String formFieldName) {
        this.formFieldName = formFieldName;
    }

    public DoubleSubmitCSRF getDoubleSubmitCSRF() {
        return this.doubleSubmitCSRF;
    }

    public void setDoubleSubmitCSRF(DoubleSubmitCSRF doubleSubmitCSRF) {
        this.doubleSubmitCSRF = doubleSubmitCSRF;
    }
}

