/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.security.csrf;

import java.io.ByteArrayOutputStream;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import net.tokensmith.jwt.builder.compact.SecureCompactBuilder;
import net.tokensmith.jwt.builder.exception.CompactException;
import net.tokensmith.jwt.config.JwtAppFactory;
import net.tokensmith.jwt.entity.jwk.Key;
import net.tokensmith.jwt.entity.jwk.SymmetricKey;
import net.tokensmith.jwt.entity.jwt.Claims;
import net.tokensmith.jwt.entity.jwt.JsonWebToken;
import net.tokensmith.jwt.entity.jwt.header.Algorithm;
import net.tokensmith.jwt.exception.InvalidJWT;
import net.tokensmith.jwt.exception.SignatureException;
import net.tokensmith.jwt.jws.verifier.VerifySignature;
import net.tokensmith.jwt.serialization.JwtSerde;
import net.tokensmith.jwt.serialization.exception.JsonToJwtException;
import net.tokensmith.otter.controller.entity.Cookie;
import net.tokensmith.otter.security.RandomString;
import net.tokensmith.otter.security.csrf.CsrfClaims;
import net.tokensmith.otter.security.csrf.exception.CsrfException;
import net.tokensmith.otter.security.entity.ChallengeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoubleSubmitCSRF {
    public static final String SIGNATURE_INVALID = "Signature Invalid";
    public static final String CSRF_FAILED = "CSRF failed validation. challengeTokensMatch: {}, noiseMatch: {}";
    private static String VERIFY_MSG = "Could not verify signature";
    private static String SERIALIZE_JWT = "Could not serialize to compact jwt";
    private static String DE_SERIALIZE_JWT = "Could not deserialize CSRF JWT to pojo";
    protected static Logger LOGGER = LoggerFactory.getLogger(DoubleSubmitCSRF.class);
    private JwtAppFactory jwtAppFactory;
    private RandomString randomString;
    private SymmetricKey preferredSignKey;
    private Map<String, SymmetricKey> rotationSignKeys;

    public DoubleSubmitCSRF(JwtAppFactory jwtAppFactory, RandomString randomString) {
        this.jwtAppFactory = jwtAppFactory;
        this.randomString = randomString;
    }

    public DoubleSubmitCSRF(JwtAppFactory jwtAppFactory, RandomString randomString, SymmetricKey preferredSignKey, Map<String, SymmetricKey> rotationSignKeys) {
        this.jwtAppFactory = jwtAppFactory;
        this.randomString = randomString;
        this.preferredSignKey = preferredSignKey;
        this.rotationSignKeys = rotationSignKeys;
    }

    public Boolean doTokensMatch(String cookieValue, String formValue) {
        CsrfClaims formClaims;
        CsrfClaims cookieClaims;
        try {
            cookieClaims = this.toClaims(cookieValue);
            formClaims = this.toClaims(formValue);
        }
        catch (CsrfException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return false;
        }
        Boolean challengeTokensMatch = cookieClaims.getChallengeToken().equals(formClaims.getChallengeToken());
        Boolean noiseMatch = cookieClaims.getNoise().equals(formClaims.getNoise());
        if (challengeTokensMatch.booleanValue() && !noiseMatch.booleanValue()) {
            return true;
        }
        LOGGER.debug(CSRF_FAILED, (Object)challengeTokensMatch, (Object)noiseMatch);
        return false;
    }

    protected CsrfClaims toClaims(String value) throws CsrfException {
        Boolean signatureValid;
        JsonWebToken csrfJwt;
        try {
            csrfJwt = this.csrfToJwt(value);
        }
        catch (CsrfException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        SymmetricKey signKey = this.getSignKey((String)csrfJwt.getHeader().getKeyId().get());
        try {
            signatureValid = this.verifyCsrfCookieSignature(csrfJwt, signKey);
        }
        catch (CsrfException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        if (!signatureValid.booleanValue()) {
            LOGGER.debug(SIGNATURE_INVALID);
            throw new CsrfException(SIGNATURE_INVALID);
        }
        CsrfClaims csrfClaims = (CsrfClaims)csrfJwt.getClaims();
        return csrfClaims;
    }

    public JsonWebToken csrfToJwt(String encodedCsrfCookieValue) throws CsrfException {
        JsonWebToken jsonWebToken;
        JwtSerde jwtSerde = this.jwtAppFactory.jwtSerde();
        try {
            jsonWebToken = jwtSerde.stringToJwt(encodedCsrfCookieValue, CsrfClaims.class);
        }
        catch (JsonToJwtException e) {
            throw new CsrfException(DE_SERIALIZE_JWT, e);
        }
        catch (InvalidJWT e) {
            throw new CsrfException(DE_SERIALIZE_JWT, e);
        }
        return jsonWebToken;
    }

    protected SymmetricKey getSignKey(String keyId) {
        SymmetricKey key = ((String)this.preferredSignKey.getKeyId().get()).equals(keyId) ? this.preferredSignKey : this.rotationSignKeys.get(keyId);
        return key;
    }

    protected Boolean verifyCsrfCookieSignature(JsonWebToken csrfJwt, SymmetricKey signKey) throws CsrfException {
        VerifySignature verifySignature;
        try {
            verifySignature = this.jwtAppFactory.verifySignature(csrfJwt.getHeader().getAlgorithm(), (Key)signKey);
        }
        catch (SignatureException e) {
            throw new CsrfException(VERIFY_MSG, e);
        }
        return verifySignature.run(csrfJwt);
    }

    public String makeChallengeToken() {
        return this.randomString.run();
    }

    public Cookie makeCsrfCookie(String name, ChallengeToken challengeToken, Boolean secure, int maxAge, Boolean isHttpOnly) throws CsrfException {
        ByteArrayOutputStream compactJwt = this.toJwt(challengeToken);
        Cookie csrfCookie = new Cookie();
        csrfCookie.setSecure(secure);
        csrfCookie.setName(name);
        csrfCookie.setMaxAge(maxAge);
        csrfCookie.setValue(compactJwt.toString());
        csrfCookie.setHttpOnly(isHttpOnly);
        return csrfCookie;
    }

    public ByteArrayOutputStream toJwt(ChallengeToken challengeToken) throws CsrfException {
        ByteArrayOutputStream compactJwt;
        Optional<Long> issuedAt = Optional.of(OffsetDateTime.now().toEpochSecond());
        CsrfClaims csrfClaims = new CsrfClaims();
        csrfClaims.setChallengeToken(challengeToken.getToken());
        csrfClaims.setNoise(challengeToken.getNoise());
        csrfClaims.setIssuedAt(issuedAt);
        SecureCompactBuilder compactBuilder = new SecureCompactBuilder();
        try {
            compactJwt = compactBuilder.alg(Algorithm.HS256).key((Key)this.preferredSignKey).claims((Claims)csrfClaims).build();
        }
        catch (CompactException e) {
            throw new CsrfException(SERIALIZE_JWT, e);
        }
        return compactJwt;
    }

    public void setPreferredSignKey(SymmetricKey preferredSignKey) {
        this.preferredSignKey = preferredSignKey;
    }

    public void setRotationSignKeys(Map<String, SymmetricKey> rotationSignKeys) {
        this.rotationSignKeys = rotationSignKeys;
    }
}

