/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.router.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.tokensmith.otter.gateway.entity.Label;
import net.tokensmith.otter.router.entity.Method;
import net.tokensmith.otter.router.entity.between.RestBetween;
import net.tokensmith.otter.security.builder.entity.RestBetweens;

public class RestBetweenFlyweight<U> {
    private Optional<RestBetween<U>> authRequired;
    private Optional<RestBetween<U>> authOptional;

    public RestBetweenFlyweight(Optional<RestBetween<U>> authRequired, Optional<RestBetween<U>> authOptional) {
        this.authRequired = authRequired;
        this.authOptional = authOptional;
    }

    public RestBetweens<U> make(Method method, List<Label> labels) {
        RestBetweens betweens = new RestBetweens(new ArrayList(), new ArrayList());
        if (Method.GET.equals((Object)method)) {
            betweens = this.makeGet(labels);
        } else if (Method.POST.equals((Object)method)) {
            betweens = this.makePost(labels);
        } else if (Method.PUT.equals((Object)method)) {
            betweens = this.makePut(labels);
        } else if (Method.PATCH.equals((Object)method)) {
            betweens = this.makePatch(labels);
        } else if (Method.DELETE.equals((Object)method)) {
            betweens = this.makeDelete(labels);
        }
        return betweens;
    }

    public RestBetweens<U> makeGet(List<Label> labels) {
        RestBetweens betweens = new RestBetweens(new ArrayList(), new ArrayList());
        this.authentication(labels, betweens);
        return betweens;
    }

    public RestBetweens<U> makePost(List<Label> labels) {
        RestBetweens betweens = new RestBetweens(new ArrayList(), new ArrayList());
        this.authentication(labels, betweens);
        return betweens;
    }

    public RestBetweens<U> makePut(List<Label> labels) {
        RestBetweens betweens = new RestBetweens(new ArrayList(), new ArrayList());
        this.authentication(labels, betweens);
        return betweens;
    }

    public RestBetweens<U> makePatch(List<Label> labels) {
        RestBetweens betweens = new RestBetweens(new ArrayList(), new ArrayList());
        this.authentication(labels, betweens);
        return betweens;
    }

    public RestBetweens<U> makeDelete(List<Label> labels) {
        RestBetweens betweens = new RestBetweens(new ArrayList(), new ArrayList());
        this.authentication(labels, betweens);
        return betweens;
    }

    protected void authentication(List<Label> labels, RestBetweens<U> betweens) {
        if (labels.contains((Object)Label.AUTH_OPTIONAL) && this.authOptional.isPresent()) {
            betweens.getBefore().add(this.authOptional.get());
        }
        if (labels.contains((Object)Label.AUTH_REQUIRED) && this.authRequired.isPresent()) {
            betweens.getBefore().add(this.authRequired.get());
        }
    }
}

