/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.router.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.tokensmith.otter.gateway.entity.Label;
import net.tokensmith.otter.router.entity.Method;
import net.tokensmith.otter.router.entity.between.Between;
import net.tokensmith.otter.security.builder.entity.Betweens;

public class BetweenFlyweight<S, U> {
    private Betweens<S, U> csrfPrepare;
    private Betweens<S, U> csrfProtect;
    private Betweens<S, U> sessionRequired;
    private Betweens<S, U> sessionOptional;
    private Optional<Between<S, U>> authRequired;
    private Optional<Between<S, U>> authOptional;

    public BetweenFlyweight(Betweens<S, U> csrfPrepare, Betweens<S, U> csrfProtect, Betweens<S, U> sessionRequired, Betweens<S, U> sessionOptional, Optional<Between<S, U>> authRequired, Optional<Between<S, U>> authOptional) {
        this.csrfPrepare = csrfPrepare;
        this.csrfProtect = csrfProtect;
        this.sessionRequired = sessionRequired;
        this.sessionOptional = sessionOptional;
        this.authRequired = authRequired;
        this.authOptional = authOptional;
    }

    public Betweens<S, U> make(Method method, List<Label> labels) {
        Betweens betweens = new Betweens(new ArrayList(), new ArrayList());
        if (Method.GET.equals((Object)method)) {
            betweens = this.makeGet(labels);
        } else if (Method.POST.equals((Object)method)) {
            betweens = this.makePost(labels);
        } else if (Method.PUT.equals((Object)method)) {
            betweens = this.makePut(labels);
        } else if (Method.PATCH.equals((Object)method)) {
            betweens = this.makePatch(labels);
        } else if (Method.DELETE.equals((Object)method)) {
            betweens = this.makeDelete(labels);
        }
        return betweens;
    }

    public Betweens<S, U> makeGet(List<Label> labels) {
        Betweens betweens = new Betweens(new ArrayList(), new ArrayList());
        if (labels.contains((Object)Label.CSRF)) {
            betweens.getBefore().addAll(this.csrfPrepare.getBefore());
        }
        if (labels.contains((Object)Label.SESSION_OPTIONAL)) {
            betweens.getBefore().addAll(this.sessionOptional.getBefore());
            betweens.getAfter().addAll(this.sessionOptional.getAfter());
        }
        if (labels.contains((Object)Label.SESSION_REQUIRED)) {
            betweens.getBefore().addAll(this.sessionRequired.getBefore());
            betweens.getAfter().addAll(this.sessionRequired.getAfter());
        }
        this.authentication(labels, betweens);
        return betweens;
    }

    public Betweens<S, U> makePost(List<Label> labels) {
        Betweens betweens = new Betweens(new ArrayList(), new ArrayList());
        if (labels.contains((Object)Label.CSRF)) {
            betweens.getBefore().addAll(this.csrfProtect.getBefore());
        }
        if (labels.contains((Object)Label.SESSION_OPTIONAL)) {
            betweens.getBefore().addAll(this.sessionOptional.getBefore());
            betweens.getAfter().addAll(this.sessionOptional.getAfter());
        }
        if (labels.contains((Object)Label.SESSION_REQUIRED)) {
            betweens.getBefore().addAll(this.sessionRequired.getBefore());
            betweens.getAfter().addAll(this.sessionRequired.getAfter());
        }
        this.authentication(labels, betweens);
        return betweens;
    }

    public Betweens<S, U> makePut(List<Label> labels) {
        Betweens betweens = new Betweens(new ArrayList(), new ArrayList());
        this.authentication(labels, betweens);
        return betweens;
    }

    public Betweens<S, U> makePatch(List<Label> labels) {
        Betweens betweens = new Betweens(new ArrayList(), new ArrayList());
        this.authentication(labels, betweens);
        return betweens;
    }

    public Betweens<S, U> makeDelete(List<Label> labels) {
        Betweens betweens = new Betweens(new ArrayList(), new ArrayList());
        this.authentication(labels, betweens);
        return betweens;
    }

    protected void authentication(List<Label> labels, Betweens<S, U> betweens) {
        if (labels.contains((Object)Label.AUTH_OPTIONAL) && this.authOptional.isPresent()) {
            betweens.getBefore().add(this.authOptional.get());
        }
        if (labels.contains((Object)Label.AUTH_REQUIRED) && this.authRequired.isPresent()) {
            betweens.getBefore().add(this.authRequired.get());
        }
    }
}

