/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.router.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.tokensmith.otter.controller.RestResource;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.controller.entity.StatusCode;
import net.tokensmith.otter.controller.entity.mime.MimeType;
import net.tokensmith.otter.dispatch.RouteRunner;
import net.tokensmith.otter.dispatch.json.JsonDispatchErrorRouteRun;
import net.tokensmith.otter.dispatch.json.JsonRouteRun;
import net.tokensmith.otter.dispatch.translator.RestErrorHandler;
import net.tokensmith.otter.dispatch.translator.rest.RestBtwnRequestTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestBtwnResponseTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestErrorRequestTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestErrorResponseTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestRequestTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestResponseTranslator;
import net.tokensmith.otter.router.builder.RestRouteBuilder;
import net.tokensmith.otter.router.entity.Location;
import net.tokensmith.otter.router.entity.RestRoute;
import net.tokensmith.otter.router.entity.between.RestBetween;
import net.tokensmith.otter.translator.JsonTranslator;
import net.tokensmith.otter.translator.config.TranslatorAppFactory;

public class RestLocationBuilder<U extends DefaultUser, P> {
    private Pattern pattern;
    private List<MimeType> contentTypes = new ArrayList<MimeType>();
    private List<MimeType> accepts = new ArrayList<MimeType>();
    private RestResource<U, P> restResource;
    private Class<P> payload;
    private List<RestBetween<U>> before = new ArrayList<RestBetween<U>>();
    private List<RestBetween<U>> after = new ArrayList<RestBetween<U>>();
    private Boolean isDispatchError = false;
    private Map<StatusCode, RouteRunner> errorRouteRunners = new HashMap<StatusCode, RouteRunner>();
    private Map<StatusCode, RestErrorHandler<U>> errorHandlers = new HashMap<StatusCode, RestErrorHandler<U>>();
    private TranslatorAppFactory translatorAppFactory = new TranslatorAppFactory();

    public RestLocationBuilder<U, P> path(String path) {
        this.pattern = Pattern.compile(path);
        return this;
    }

    public RestLocationBuilder<U, P> contentTypes(List<MimeType> contentTypes) {
        this.contentTypes = contentTypes;
        return this;
    }

    public RestLocationBuilder<U, P> contentType(MimeType contentType) {
        this.contentTypes.add(contentType);
        return this;
    }

    public RestLocationBuilder<U, P> accepts(List<MimeType> contentTypes) {
        this.accepts = contentTypes;
        return this;
    }

    public RestLocationBuilder<U, P> accept(MimeType contentType) {
        this.accepts.add(contentType);
        return this;
    }

    public RestLocationBuilder<U, P> restResource(RestResource<U, P> restResource) {
        this.restResource = restResource;
        return this;
    }

    public RestLocationBuilder<U, P> payload(Class<P> payload) {
        this.payload = payload;
        return this;
    }

    public RestLocationBuilder<U, P> before(List<RestBetween<U>> before) {
        this.before = before;
        return this;
    }

    public RestLocationBuilder<U, P> after(List<RestBetween<U>> after) {
        this.after = after;
        return this;
    }

    public RestLocationBuilder<U, P> errorRouteRunner(StatusCode statusCode, RouteRunner errorRouteRunner) {
        this.errorRouteRunners.put(statusCode, errorRouteRunner);
        return this;
    }

    public RestLocationBuilder<U, P> restErrorHandlers(Map<StatusCode, RestErrorHandler<U>> restErrorHandlers) {
        for (Map.Entry<StatusCode, RestErrorHandler<U>> entry : restErrorHandlers.entrySet()) {
            this.errorHandlers.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public RestLocationBuilder<U, P> isDispatchError(Boolean isDispatchError) {
        this.isDispatchError = isDispatchError;
        return this;
    }

    public Location build() {
        RestRoute restRoute = new RestRouteBuilder<U, P>().restResource(this.restResource).before(this.before).after(this.after).build();
        JsonTranslator<P> jsonTranslator = this.translatorAppFactory.jsonTranslator(this.payload);
        RestRequestTranslator restRequestTranslator = new RestRequestTranslator();
        RestResponseTranslator restResponseTranslator = new RestResponseTranslator();
        RestBtwnRequestTranslator restBtwnRequestTranslator = new RestBtwnRequestTranslator();
        RestBtwnResponseTranslator restBtwnResponseTranslator = new RestBtwnResponseTranslator();
        JsonRouteRun routeRunner = this.isDispatchError != false ? new JsonDispatchErrorRouteRun(restRoute, restResponseTranslator, restRequestTranslator, restBtwnRequestTranslator, restBtwnResponseTranslator, jsonTranslator, this.errorHandlers, new RestErrorRequestTranslator(), new RestErrorResponseTranslator()) : new JsonRouteRun(restRoute, restResponseTranslator, restRequestTranslator, restBtwnRequestTranslator, restBtwnResponseTranslator, jsonTranslator, this.errorHandlers, new RestErrorRequestTranslator(), new RestErrorResponseTranslator());
        return new Location(this.pattern, this.contentTypes, this.accepts, routeRunner, this.errorRouteRunners);
    }
}

