/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.router.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.tokensmith.otter.controller.Resource;
import net.tokensmith.otter.controller.entity.DefaultSession;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.controller.entity.StatusCode;
import net.tokensmith.otter.controller.entity.mime.MimeType;
import net.tokensmith.otter.dispatch.RouteRunner;
import net.tokensmith.otter.dispatch.html.RouteRun;
import net.tokensmith.otter.dispatch.translator.AnswerTranslator;
import net.tokensmith.otter.dispatch.translator.RequestTranslator;
import net.tokensmith.otter.router.builder.RouteBuilder;
import net.tokensmith.otter.router.entity.Location;
import net.tokensmith.otter.router.entity.Route;
import net.tokensmith.otter.router.entity.between.Between;

public class LocationBuilder<S extends DefaultSession, U extends DefaultUser> {
    private Pattern pattern;
    private List<MimeType> contentTypes = new ArrayList<MimeType>();
    private List<MimeType> accepts = new ArrayList<MimeType>();
    private Resource<S, U> resource;
    private List<Between<S, U>> before = new ArrayList<Between<S, U>>();
    private List<Between<S, U>> after = new ArrayList<Between<S, U>>();
    private Map<StatusCode, RouteRunner> errorRouteRunners = new HashMap<StatusCode, RouteRunner>();
    private Map<StatusCode, Resource<S, U>> errorResources = new HashMap<StatusCode, Resource<S, U>>();
    private RequestTranslator<S, U> requestTranslator = new RequestTranslator();
    private AnswerTranslator<S> answerTranslator = new AnswerTranslator();

    public LocationBuilder<S, U> path(String path) {
        this.pattern = Pattern.compile(path);
        return this;
    }

    public LocationBuilder<S, U> contentTypes(List<MimeType> contentTypes) {
        this.contentTypes = contentTypes;
        return this;
    }

    public LocationBuilder<S, U> contentType(MimeType contentType) {
        this.contentTypes.add(contentType);
        return this;
    }

    public LocationBuilder<S, U> accepts(List<MimeType> contentTypes) {
        this.accepts = contentTypes;
        return this;
    }

    public LocationBuilder<S, U> accept(MimeType contentType) {
        this.accepts.add(contentType);
        return this;
    }

    public LocationBuilder<S, U> resource(Resource<S, U> resource) {
        this.resource = resource;
        return this;
    }

    public LocationBuilder<S, U> before(List<Between<S, U>> before) {
        this.before = before;
        return this;
    }

    public LocationBuilder<S, U> after(List<Between<S, U>> after) {
        this.after = after;
        return this;
    }

    public LocationBuilder<S, U> errorRouteRunners(Map<StatusCode, Route<S, U>> errorRoutes) {
        for (Map.Entry<StatusCode, Route<S, U>> entry : errorRoutes.entrySet()) {
            RouteRun<S, U> errorRouteRunner = new RouteRun<S, U>(entry.getValue(), this.requestTranslator, this.answerTranslator, this.errorResources);
            this.errorRouteRunners.put(entry.getKey(), errorRouteRunner);
        }
        return this;
    }

    public LocationBuilder<S, U> errorRouteRunner(StatusCode statusCode, Resource<S, U> resource) {
        Route errorRoute = new RouteBuilder<S, U>().resource(resource).before(new ArrayList()).after(new ArrayList()).build();
        RouteRun errorRouteRunner = new RouteRun(errorRoute, this.requestTranslator, this.answerTranslator, this.errorResources);
        this.errorRouteRunners.put(statusCode, errorRouteRunner);
        return this;
    }

    public LocationBuilder<S, U> errorResources(Map<StatusCode, Resource<S, U>> errorResources) {
        this.errorResources = errorResources;
        return this;
    }

    public Location build() {
        Route route = new RouteBuilder<S, U>().resource(this.resource).before(this.before).after(this.after).build();
        RouteRun routeRunner = new RouteRun(route, this.requestTranslator, this.answerTranslator, this.errorResources);
        return new Location(this.pattern, this.contentTypes, this.accepts, routeRunner, this.errorRouteRunners);
    }
}

