/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import net.tokensmith.otter.router.entity.Location;
import net.tokensmith.otter.router.entity.MatchedLocation;
import net.tokensmith.otter.router.entity.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher {
    protected static Logger LOGGER = LoggerFactory.getLogger(Dispatcher.class);
    private static String OTTER_PREFIX = "/app";
    private static String EMPTY = "";
    private List<Location> get = new ArrayList<Location>();
    private List<Location> post = new ArrayList<Location>();
    private List<Location> put = new ArrayList<Location>();
    private List<Location> patch = new ArrayList<Location>();
    private List<Location> delete = new ArrayList<Location>();
    private List<Location> connect = new ArrayList<Location>();
    private List<Location> options = new ArrayList<Location>();
    private List<Location> trace = new ArrayList<Location>();
    private List<Location> head = new ArrayList<Location>();

    public Optional<MatchedLocation> find(Method method, String url) {
        String scrubbedUrl = url.replaceAll(OTTER_PREFIX, EMPTY);
        Optional<MatchedLocation> m = Optional.empty();
        for (Location location : this.locations(method)) {
            Matcher matcher = location.getPattern().matcher(scrubbedUrl);
            if (!matcher.matches()) continue;
            m = Optional.of(new MatchedLocation(matcher, location));
            break;
        }
        return m;
    }

    public List<Location> locations(Method method) {
        if (method == Method.GET) {
            return this.get;
        }
        if (method == Method.POST) {
            return this.post;
        }
        if (method == Method.PUT) {
            return this.put;
        }
        if (method == Method.PATCH) {
            return this.patch;
        }
        if (method == Method.DELETE) {
            return this.delete;
        }
        if (method == Method.CONNECT) {
            return this.connect;
        }
        if (method == Method.OPTIONS) {
            return this.options;
        }
        if (method == Method.TRACE) {
            return this.trace;
        }
        if (method == Method.HEAD) {
            return this.head;
        }
        return new ArrayList<Location>();
    }

    public List<Location> getGet() {
        return this.get;
    }

    public List<Location> getPost() {
        return this.post;
    }

    public List<Location> getPut() {
        return this.put;
    }

    public List<Location> getPatch() {
        return this.patch;
    }

    public List<Location> getDelete() {
        return this.delete;
    }

    public List<Location> getConnect() {
        return this.connect;
    }

    public List<Location> getOptions() {
        return this.options;
    }

    public List<Location> getTrace() {
        return this.trace;
    }

    public List<Location> getHead() {
        return this.head;
    }
}

