/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.gateway.translator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.controller.entity.StatusCode;
import net.tokensmith.otter.controller.entity.mime.MimeType;
import net.tokensmith.otter.dispatch.RouteRunner;
import net.tokensmith.otter.dispatch.config.DispatchAppFactory;
import net.tokensmith.otter.dispatch.translator.RestErrorHandler;
import net.tokensmith.otter.gateway.entity.rest.RestError;
import net.tokensmith.otter.gateway.entity.rest.RestErrorTarget;
import net.tokensmith.otter.gateway.entity.rest.RestTarget;
import net.tokensmith.otter.router.builder.RestLocationBuilder;
import net.tokensmith.otter.router.entity.Location;
import net.tokensmith.otter.router.entity.Method;
import net.tokensmith.otter.router.entity.RestRoute;
import net.tokensmith.otter.router.factory.RestBetweenFlyweight;
import net.tokensmith.otter.security.builder.entity.RestBetweens;
import net.tokensmith.otter.translatable.Translatable;

public class RestLocationTranslator<U extends DefaultUser, P> {
    private static DispatchAppFactory dispatchAppFactory = new DispatchAppFactory();
    private RestBetweenFlyweight<U> restBetweenFlyweight;
    private Map<StatusCode, RestError<U, ? extends Translatable>> restErrors;
    private Map<StatusCode, RestError<U, ? extends Translatable>> defaultErrors;
    private Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> dispatchErrors;
    private Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> defaultDispatchErrors;

    public RestLocationTranslator(RestBetweenFlyweight<U> restBetweenFlyweight, Map<StatusCode, RestError<U, ? extends Translatable>> restErrors, Map<StatusCode, RestError<U, ? extends Translatable>> defaultErrors, Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> dispatchErrors, Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> defaultDispatchErrors) {
        this.restBetweenFlyweight = restBetweenFlyweight;
        this.restErrors = restErrors;
        this.defaultErrors = defaultErrors;
        this.dispatchErrors = dispatchErrors;
        this.defaultDispatchErrors = defaultDispatchErrors;
    }

    public Map<Method, Location> to(RestTarget<U, P> from) {
        Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> mergedDispatchErrors = this.mergeDispatchErrors(this.defaultDispatchErrors, this.dispatchErrors);
        Map<StatusCode, RestErrorHandler<U>> errorHandlers = this.toErrorHandlers(from.getRestErrors());
        Map<Method, Location> to = this.to(from, false, errorHandlers, mergedDispatchErrors);
        return to;
    }

    public Map<Method, Location> toNotFound(RestTarget<U, P> from) {
        Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> mergedDispatchErrors = this.mergeDispatchErrors(this.defaultDispatchErrors, this.dispatchErrors);
        Map<StatusCode, RestErrorHandler<U>> errorHandlers = this.toErrorHandlers(from.getRestErrors());
        Map<Method, Location> to = this.to(from, true, errorHandlers, mergedDispatchErrors);
        return to;
    }

    protected Map<Method, Location> to(RestTarget<U, P> from, Boolean isDispatchError, Map<StatusCode, RestErrorHandler<U>> errorHandlers, Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> mergedDispatchErrors) {
        HashMap<Method, Location> to = new HashMap<Method, Location>();
        for (Method method : from.getMethods()) {
            RestLocationBuilder<U, P> locationBuilder = this.makeLocationBuilder(method, from, errorHandlers, mergedDispatchErrors);
            locationBuilder.isDispatchError(isDispatchError);
            to.put(method, locationBuilder.build());
        }
        return to;
    }

    protected RestLocationBuilder<U, P> makeLocationBuilder(Method method, RestTarget<U, P> from, Map<StatusCode, RestErrorHandler<U>> errorHandlers, Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> mergedDispatchErrors) {
        List<MimeType> accepts;
        RestBetweens<U> betweens = this.restBetweenFlyweight.make(method, from.getLabels());
        List<MimeType> contentTypes = from.getContentTypes().get((Object)method);
        if (contentTypes == null) {
            contentTypes = new ArrayList<MimeType>();
        }
        if ((accepts = from.getAccepts().get((Object)method)) == null) {
            accepts = new ArrayList<MimeType>();
        }
        RestLocationBuilder locationBuilder = new RestLocationBuilder().path(from.getRegex()).contentTypes(contentTypes).accepts(accepts).restResource(from.getRestResource()).payload(from.getPayload()).before(Stream.of(betweens.getBefore(), from.getBefore()).flatMap(Collection::stream).collect(Collectors.toList())).after(Stream.of(betweens.getAfter(), from.getAfter()).flatMap(Collection::stream).collect(Collectors.toList())).restErrorHandlers(errorHandlers);
        Map<StatusCode, RestErrorTarget<U, Translatable>> dispatchErrors = this.mergeDispatchErrors(mergedDispatchErrors, from.getErrorTargets());
        for (Map.Entry<StatusCode, RestErrorTarget<U, Translatable>> entry : dispatchErrors.entrySet()) {
            RestRoute<U, Translatable> restRoute = dispatchAppFactory.makeRestRoute(entry.getValue());
            RouteRunner restRouteRunner = dispatchAppFactory.makeJsonDispatchErrorRouteRun(restRoute, entry.getValue().getPayload());
            locationBuilder = locationBuilder.errorRouteRunner(entry.getKey(), restRouteRunner);
        }
        return locationBuilder;
    }

    protected Map<StatusCode, RestError<U, ? extends Translatable>> mergeRestErrors(Map<StatusCode, RestError<U, ? extends Translatable>> left, Map<StatusCode, RestError<U, ? extends Translatable>> right) {
        Map<StatusCode, RestError<U, ? extends Translatable>> to = Stream.of(left, right).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2));
        return to;
    }

    protected Map<StatusCode, RestErrorHandler<U>> toErrorHandlers(Map<StatusCode, RestError<U, ? extends Translatable>> from) {
        HashMap<StatusCode, RestErrorHandler<U>> to = new HashMap<StatusCode, RestErrorHandler<U>>();
        Map<StatusCode, RestError<U, ? extends Translatable>> mergedRestErrors = this.mergeRestErrors(this.defaultErrors, this.restErrors);
        Map<StatusCode, RestError<U, Translatable>> fromMerged = this.mergeRestErrors(mergedRestErrors, from);
        for (Map.Entry<StatusCode, RestError<U, Translatable>> entry : fromMerged.entrySet()) {
            to.put(entry.getKey(), dispatchAppFactory.restErrorHandler(entry.getValue()));
        }
        return to;
    }

    protected Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> mergeDispatchErrors(Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> left, Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> right) {
        Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> to = Stream.of(left, right).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v2));
        return to;
    }
}

