/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.gateway.servlet.translator;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import net.tokensmith.otter.QueryStringToMap;
import net.tokensmith.otter.controller.entity.Cookie;
import net.tokensmith.otter.controller.entity.mime.MimeType;
import net.tokensmith.otter.controller.entity.mime.SubType;
import net.tokensmith.otter.controller.entity.mime.TopLevelType;
import net.tokensmith.otter.controller.header.Header;
import net.tokensmith.otter.gateway.servlet.translator.HttpServletRequestCookieTranslator;
import net.tokensmith.otter.gateway.servlet.translator.HttpServletRequestHeaderTranslator;
import net.tokensmith.otter.router.builder.AskBuilder;
import net.tokensmith.otter.router.entity.Method;
import net.tokensmith.otter.router.entity.io.Ask;
import net.tokensmith.otter.translator.MimeTypeTranslator;

public class HttpServletRequestTranslator {
    private static String PARAM_DELIMITER = "?";
    private static String EMPTY = "";
    private HttpServletRequestCookieTranslator httpServletCookieTranslator;
    private HttpServletRequestHeaderTranslator httpServletRequestHeaderTranslator;
    private QueryStringToMap queryStringToMap;
    private MimeTypeTranslator mimeTypeTranslator;

    public HttpServletRequestTranslator(HttpServletRequestCookieTranslator httpServletCookieTranslator, HttpServletRequestHeaderTranslator httpServletRequestHeaderTranslator, QueryStringToMap queryStringToMap, MimeTypeTranslator mimeTypeTranslator) {
        this.httpServletCookieTranslator = httpServletCookieTranslator;
        this.httpServletRequestHeaderTranslator = httpServletRequestHeaderTranslator;
        this.queryStringToMap = queryStringToMap;
        this.mimeTypeTranslator = mimeTypeTranslator;
    }

    public Ask from(HttpServletRequest containerRequest, byte[] containerBody) throws IOException {
        Method method = Method.valueOf(containerRequest.getMethod());
        String pathWithParams = containerRequest.getRequestURI() + this.queryStringForUrl(containerRequest.getQueryString());
        HashMap<String, Cookie> otterCookies = new HashMap();
        if (containerRequest.getCookies() != null) {
            otterCookies = Arrays.asList(containerRequest.getCookies()).stream().collect(Collectors.toMap(javax.servlet.http.Cookie::getName, this.httpServletCookieTranslator.from));
        }
        Map<String, String> headers = this.httpServletRequestHeaderTranslator.from(containerRequest);
        Optional<String> queryString = Optional.ofNullable(containerRequest.getQueryString());
        Map<String, List<String>> queryParams = this.queryStringToMap.run(queryString);
        MimeType contentType = this.mimeTypeTranslator.to(containerRequest.getContentType());
        String acceptFrom = containerRequest.getHeader(Header.ACCEPT.getValue());
        MimeType acceptTo = this.mimeTypeTranslator.to(acceptFrom);
        HashMap<String, List<String>> formData = new HashMap();
        Optional<byte[]> body = Optional.empty();
        if (this.isForm(method, contentType).booleanValue()) {
            String form = new String(containerBody);
            formData = this.queryStringToMap.run(Optional.of(form));
        } else if (method == Method.POST && !this.isForm(method, contentType).booleanValue()) {
            body = Optional.of(containerBody);
        }
        String ipAddress = containerRequest.getRemoteAddr();
        return new AskBuilder().matcher(Optional.empty()).method(method).pathWithParams(pathWithParams).contentType(contentType).accept(acceptTo).cookies(otterCookies).headers(headers).queryParams(queryParams).formData(formData).body(body).csrfChallenge(Optional.empty()).ipAddress(ipAddress).build();
    }

    protected Boolean isForm(Method method, MimeType contentType) {
        return method == Method.POST && TopLevelType.APPLICATION.toString().equals(contentType.getType()) && SubType.FORM.toString().equals(contentType.getSubType());
    }

    protected String queryStringForUrl(String queryString) {
        Object queryStringForUrl = queryString != null ? PARAM_DELIMITER + queryString : EMPTY;
        return queryStringForUrl;
    }
}

