/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.gateway.servlet.merger;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.tokensmith.otter.controller.entity.Cookie;
import net.tokensmith.otter.gateway.servlet.translator.HttpServletRequestCookieTranslator;
import net.tokensmith.otter.router.entity.io.Answer;

public class HttpServletResponseMerger {
    private HttpServletRequestCookieTranslator httpServletRequestCookieTranslator;

    public HttpServletResponseMerger(HttpServletRequestCookieTranslator httpServletRequestCookieTranslator) {
        this.httpServletRequestCookieTranslator = httpServletRequestCookieTranslator;
    }

    public HttpServletResponse merge(HttpServletResponse containerResponse, javax.servlet.http.Cookie[] containerCookies, Answer answer) {
        for (Map.Entry<String, String> header : answer.getHeaders().entrySet()) {
            containerResponse.setHeader(header.getKey(), header.getValue());
        }
        Map<String, javax.servlet.http.Cookie> containerCookiesMap = this.deleteAndUpdateCookies(containerResponse, containerCookies, answer);
        this.createCookies(containerResponse, containerCookiesMap, answer.getCookies());
        containerResponse.setStatus(answer.getStatusCode().getCode().intValue());
        return containerResponse;
    }

    protected Map<String, javax.servlet.http.Cookie> deleteAndUpdateCookies(HttpServletResponse containerResponse, javax.servlet.http.Cookie[] containerCookies, Answer answer) {
        HashMap<String, javax.servlet.http.Cookie> containerCookiesMap = new HashMap<String, javax.servlet.http.Cookie>();
        if (containerCookies == null) {
            return containerCookiesMap;
        }
        for (javax.servlet.http.Cookie containerCookie : containerCookies) {
            containerCookiesMap.put(containerCookie.getName(), containerCookie);
            Cookie otterCookie = answer.getCookies().get(containerCookie.getName());
            if (otterCookie == null) {
                containerCookie.setMaxAge(0);
                containerResponse.addCookie(containerCookie);
                continue;
            }
            containerCookie = this.httpServletRequestCookieTranslator.to.apply(otterCookie);
            containerResponse.addCookie(containerCookie);
        }
        return containerCookiesMap;
    }

    protected void createCookies(HttpServletResponse containerResponse, Map<String, javax.servlet.http.Cookie> containerCookiesMap, Map<String, Cookie> otterCookies) {
        for (Map.Entry<String, Cookie> otterCookie : otterCookies.entrySet()) {
            javax.servlet.http.Cookie containerCookie = containerCookiesMap.get(otterCookie.getKey());
            if (containerCookie != null) continue;
            javax.servlet.http.Cookie containerCookieToAdd = this.httpServletRequestCookieTranslator.to.apply(otterCookie.getValue());
            containerResponse.addCookie(containerCookieToAdd);
        }
    }
}

