/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.gateway.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.tokensmith.otter.controller.entity.DefaultSession;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.gateway.Gateway;
import net.tokensmith.otter.gateway.servlet.GatewayResponse;
import net.tokensmith.otter.gateway.servlet.merger.HttpServletRequestMerger;
import net.tokensmith.otter.gateway.servlet.merger.HttpServletResponseMerger;
import net.tokensmith.otter.gateway.servlet.translator.HttpServletRequestTranslator;
import net.tokensmith.otter.gateway.translator.LocationTranslator;
import net.tokensmith.otter.gateway.translator.RestLocationTranslator;
import net.tokensmith.otter.router.Engine;
import net.tokensmith.otter.router.builder.AnswerBuilder;
import net.tokensmith.otter.router.entity.io.Answer;
import net.tokensmith.otter.router.entity.io.Ask;
import net.tokensmith.otter.router.exception.HaltException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletGateway
extends Gateway {
    protected static Logger LOGGER = LoggerFactory.getLogger(ServletGateway.class);
    private HttpServletRequestTranslator httpServletRequestTranslator;
    private HttpServletRequestMerger httpServletRequestMerger;
    private HttpServletResponseMerger httpServletResponseMerger;
    private Integer writeChunkSize;

    public ServletGateway(HttpServletRequestTranslator httpServletRequestTranslator, HttpServletRequestMerger httpServletRequestMerger, HttpServletResponseMerger httpServletResponseMerger, Engine engine, Map<String, LocationTranslator<? extends DefaultSession, ? extends DefaultUser>> locationTranslators, Map<String, RestLocationTranslator<? extends DefaultUser, ?>> restLocationTranslators, Integer writeChunkSize) {
        super(engine, locationTranslators, restLocationTranslators);
        this.httpServletRequestTranslator = httpServletRequestTranslator;
        this.httpServletRequestMerger = httpServletRequestMerger;
        this.httpServletResponseMerger = httpServletResponseMerger;
        this.writeChunkSize = writeChunkSize;
    }

    public GatewayResponse processRequest(HttpServletRequest containerRequest, HttpServletResponse containerResponse, byte[] body) {
        GatewayResponse gatewayResponse = new GatewayResponse();
        try {
            Answer resourceAnswer;
            Ask ask = this.httpServletRequestTranslator.from(containerRequest, body);
            Answer answer = new AnswerBuilder().headers(new HashMap<String, String>()).cookies(ask.getCookies()).payload(Optional.empty()).presenter(Optional.empty()).template(Optional.empty()).build();
            try {
                resourceAnswer = this.engine.route(ask, answer);
            }
            catch (HaltException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
                resourceAnswer = answer;
            }
            this.httpServletResponseMerger.merge(containerResponse, containerRequest.getCookies(), resourceAnswer);
            this.httpServletRequestMerger.merge(containerRequest, resourceAnswer);
            if (resourceAnswer.getPayload().isPresent()) {
                gatewayResponse.setPayload(Optional.of(resourceAnswer.getPayload().get()));
            } else {
                gatewayResponse.setPayload(Optional.empty());
            }
            gatewayResponse.setWriteChunkSize(this.writeChunkSize);
            gatewayResponse.setTemplate(resourceAnswer.getTemplate());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            containerResponse.setStatus(500);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            containerResponse.setStatus(500);
        }
        return gatewayResponse;
    }
}

