/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.gateway.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.tokensmith.otter.controller.Resource;
import net.tokensmith.otter.controller.entity.DefaultSession;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.controller.entity.StatusCode;
import net.tokensmith.otter.controller.entity.mime.MimeType;
import net.tokensmith.otter.gateway.entity.ErrorTarget;
import net.tokensmith.otter.gateway.entity.Label;
import net.tokensmith.otter.gateway.entity.Target;
import net.tokensmith.otter.router.entity.Method;
import net.tokensmith.otter.router.entity.between.Between;

public class TargetBuilder<S extends DefaultSession, U extends DefaultUser> {
    private List<Method> methods = new ArrayList<Method>();
    private String regex;
    private Resource<S, U> resource;
    private Map<Method, List<MimeType>> contentTypes = new HashMap<Method, List<MimeType>>();
    private Map<Method, List<MimeType>> accepts = new HashMap<Method, List<MimeType>>();
    private List<Label> labels = new ArrayList<Label>(Arrays.asList(Label.SESSION_OPTIONAL, Label.AUTH_OPTIONAL));
    private List<Between<S, U>> before = new ArrayList<Between<S, U>>();
    private List<Between<S, U>> after = new ArrayList<Between<S, U>>();
    private Map<StatusCode, ErrorTarget<S, U>> errorTargets = new HashMap<StatusCode, ErrorTarget<S, U>>();
    private Map<StatusCode, Resource<S, U>> errorResources = new HashMap<StatusCode, Resource<S, U>>();
    private String groupName;

    public TargetBuilder<S, U> method(Method method) {
        this.methods.add(method);
        return this;
    }

    public TargetBuilder<S, U> form() {
        this.method(Method.GET).method(Method.POST);
        this.labels.add(Label.CSRF);
        return this;
    }

    public TargetBuilder<S, U> regex(String regex) {
        this.regex = regex;
        return this;
    }

    public TargetBuilder<S, U> resource(Resource<S, U> resource) {
        this.resource = resource;
        return this;
    }

    public TargetBuilder<S, U> contentType(MimeType contentType) {
        for (Method method : Method.values()) {
            this.contentType(method, contentType);
        }
        return this;
    }

    public TargetBuilder<S, U> contentType(Method method, MimeType contentType) {
        List<MimeType> mimeTypes = this.contentTypes.get((Object)method);
        if (mimeTypes == null) {
            mimeTypes = new ArrayList<MimeType>();
        }
        mimeTypes.add(contentType);
        this.contentTypes.put(method, mimeTypes);
        return this;
    }

    public TargetBuilder<S, U> accept(MimeType contentType) {
        for (Method method : Method.values()) {
            this.accept(method, contentType);
        }
        return this;
    }

    public TargetBuilder<S, U> accept(Method method, MimeType contentType) {
        List<MimeType> mimeTypes = this.accepts.get((Object)method);
        if (mimeTypes == null) {
            mimeTypes = new ArrayList<MimeType>();
        }
        mimeTypes.add(contentType);
        this.accepts.put(method, mimeTypes);
        return this;
    }

    public TargetBuilder<S, U> authenticate() {
        this.labels.remove((Object)Label.SESSION_OPTIONAL);
        this.labels.remove((Object)Label.AUTH_OPTIONAL);
        this.labels.add(Label.SESSION_REQUIRED);
        this.labels.add(Label.AUTH_REQUIRED);
        return this;
    }

    public TargetBuilder<S, U> anonymous() {
        this.labels.remove((Object)Label.SESSION_OPTIONAL);
        this.labels.remove((Object)Label.AUTH_OPTIONAL);
        this.labels.remove((Object)Label.SESSION_REQUIRED);
        this.labels.remove((Object)Label.AUTH_REQUIRED);
        return this;
    }

    public TargetBuilder<S, U> before(Between<S, U> before) {
        this.before.add(before);
        return this;
    }

    public TargetBuilder<S, U> after(Between<S, U> after) {
        this.after.add(after);
        return this;
    }

    public TargetBuilder<S, U> onDispatchError(StatusCode statusCode, ErrorTarget<S, U> errorTarget) {
        this.errorTargets.put(statusCode, errorTarget);
        return this;
    }

    public TargetBuilder<S, U> onError(StatusCode statusCode, Resource<S, U> errorResource) {
        this.errorResources.put(statusCode, errorResource);
        return this;
    }

    public TargetBuilder<S, U> groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public Target<S, U> build() {
        return new Target<S, U>(this.methods, this.regex, this.resource, this.contentTypes, this.accepts, this.labels, this.before, this.after, this.errorTargets, this.errorResources, this.groupName);
    }
}

