/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.gateway;

import java.util.Map;
import java.util.Optional;
import net.tokensmith.otter.controller.Resource;
import net.tokensmith.otter.controller.entity.DefaultSession;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.controller.entity.StatusCode;
import net.tokensmith.otter.gateway.entity.ErrorTarget;
import net.tokensmith.otter.gateway.entity.Shape;
import net.tokensmith.otter.gateway.translator.LocationTranslator;
import net.tokensmith.otter.router.entity.between.Between;
import net.tokensmith.otter.router.factory.BetweenFlyweight;
import net.tokensmith.otter.security.builder.BetweenBuilder;
import net.tokensmith.otter.security.builder.entity.Betweens;
import net.tokensmith.otter.security.exception.SessionCtorException;
import net.tokensmith.otter.translator.config.TranslatorAppFactory;

public class LocationTranslatorFactory {
    private Shape shape;

    public LocationTranslatorFactory(Shape shape) {
        this.shape = shape;
    }

    public <S extends DefaultSession, U extends DefaultUser> LocationTranslator<S, U> make(Class<S> sessionClazz, Optional<Between<S, U>> authRequired, Optional<Between<S, U>> authOptional, Map<StatusCode, Resource<S, U>> errorResources, Map<StatusCode, ErrorTarget<S, U>> dispatchErrors, Map<StatusCode, ErrorTarget<S, U>> defaultDispatchErrors) throws SessionCtorException {
        return new LocationTranslator<S, U>(this.betweenFlyweight(sessionClazz, authRequired, authOptional), errorResources, dispatchErrors, defaultDispatchErrors);
    }

    public <S, U> BetweenFlyweight<S, U> betweenFlyweight(Class<S> sessionClazz, Optional<Between<S, U>> authRequired, Optional<Between<S, U>> authOptional) throws SessionCtorException {
        TranslatorAppFactory appFactory = new TranslatorAppFactory();
        return new BetweenFlyweight<S, U>(this.csrfPrepare(appFactory), this.csrfProtect(appFactory), this.session(appFactory, sessionClazz), this.sessionOptional(appFactory, sessionClazz), authRequired, authOptional);
    }

    protected <S, U> Betweens<S, U> csrfPrepare(TranslatorAppFactory appFactory) {
        return new BetweenBuilder().routerAppFactory(appFactory).secure(this.shape.getSecure()).signKey(this.shape.getSignkey()).rotationSignKeys(this.shape.getRotationSignKeys()).csrfPrepare().build();
    }

    protected <S, U> Betweens<S, U> csrfProtect(TranslatorAppFactory appFactory) {
        return new BetweenBuilder().routerAppFactory(appFactory).secure(this.shape.getSecure()).signKey(this.shape.getSignkey()).rotationSignKeys(this.shape.getRotationSignKeys()).csrfProtect().build();
    }

    protected <S, U> Betweens<S, U> session(TranslatorAppFactory appFactory, Class<S> sessionClazz) throws SessionCtorException {
        return new BetweenBuilder().routerAppFactory(appFactory).secure(this.shape.getSecure()).encKey(this.shape.getEncKey()).rotationEncKey(this.shape.getRotationEncKeys()).sessionClass(sessionClazz).session().build();
    }

    protected <S, U> Betweens<S, U> sessionOptional(TranslatorAppFactory appFactory, Class<S> sessionClazz) throws SessionCtorException {
        return new BetweenBuilder().routerAppFactory(appFactory).secure(this.shape.getSecure()).encKey(this.shape.getEncKey()).rotationEncKey(this.shape.getRotationEncKeys()).sessionClass(sessionClazz).optionalSession().build();
    }
}

