/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.gateway;

import java.util.Map;
import net.tokensmith.otter.controller.entity.DefaultSession;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.gateway.entity.Target;
import net.tokensmith.otter.gateway.entity.rest.RestTarget;
import net.tokensmith.otter.gateway.translator.LocationTranslator;
import net.tokensmith.otter.gateway.translator.RestLocationTranslator;
import net.tokensmith.otter.router.Dispatcher;
import net.tokensmith.otter.router.Engine;
import net.tokensmith.otter.router.entity.Location;
import net.tokensmith.otter.router.entity.Method;

public class Gateway {
    protected Engine engine;
    protected Map<String, LocationTranslator<? extends DefaultSession, ? extends DefaultUser>> locationTranslators;
    protected Map<String, RestLocationTranslator<? extends DefaultUser, ?>> restLocationTranslators;

    public Gateway(Engine engine, Map<String, LocationTranslator<? extends DefaultSession, ? extends DefaultUser>> locationTranslators, Map<String, RestLocationTranslator<? extends DefaultUser, ?>> restLocationTranslators) {
        this.engine = engine;
        this.locationTranslators = locationTranslators;
        this.restLocationTranslators = restLocationTranslators;
    }

    protected Location add(Dispatcher dispatcher, Method method, Location location) {
        dispatcher.locations(method).add(location);
        return location;
    }

    public <S extends DefaultSession, U extends DefaultUser> void add(Target<S, U> target) {
        LocationTranslator<S, U> locationTranslator = this.locationTranslator(target.getGroupName());
        Map<Method, Location> locations = locationTranslator.to(target);
        for (Map.Entry<Method, Location> location : locations.entrySet()) {
            this.add(this.engine.getDispatcher(), location.getKey(), location.getValue());
        }
    }

    public <U extends DefaultUser, P> void add(RestTarget<U, P> restTarget) {
        RestLocationTranslator<U, P> restLocationTranslator = this.restLocationTranslator(restTarget.getGroupName());
        Map<Method, Location> locations = restLocationTranslator.to(restTarget);
        for (Map.Entry<Method, Location> location : locations.entrySet()) {
            this.add(this.engine.getDispatcher(), location.getKey(), location.getValue());
        }
    }

    public <S extends DefaultSession, U extends DefaultUser> LocationTranslator<S, U> locationTranslator(String groupName) {
        return this.locationTranslators.get(groupName);
    }

    public <U extends DefaultUser, P> RestLocationTranslator<U, P> restLocationTranslator(String groupName) {
        return this.restLocationTranslators.get(groupName);
    }

    public <S extends DefaultSession, U extends DefaultUser> void notFound(Target<S, U> notFound) {
        LocationTranslator<S, U> locationTranslator = this.locationTranslator(notFound.getGroupName());
        Map<Method, Location> locations = locationTranslator.to(notFound);
        for (Map.Entry<Method, Location> location : locations.entrySet()) {
            this.add(this.engine.getNotFoundDispatcher(), location.getKey(), location.getValue());
        }
    }

    public <U extends DefaultUser, P> void notFound(RestTarget<U, P> notFound) {
        RestLocationTranslator<U, P> restLocationTranslator = this.restLocationTranslator(notFound.getGroupName());
        Map<Method, Location> locations = restLocationTranslator.toNotFound(notFound);
        for (Map.Entry<Method, Location> location : locations.entrySet()) {
            this.add(this.engine.getNotFoundDispatcher(), location.getKey(), location.getValue());
        }
    }
}

