/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.dispatch.json;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.tokensmith.otter.controller.RestResource;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.controller.entity.StatusCode;
import net.tokensmith.otter.controller.entity.request.RestRequest;
import net.tokensmith.otter.controller.entity.response.RestResponse;
import net.tokensmith.otter.dispatch.RouteRunner;
import net.tokensmith.otter.dispatch.builder.RestResponseErrorBuilder;
import net.tokensmith.otter.dispatch.entity.RestBtwnRequest;
import net.tokensmith.otter.dispatch.entity.RestBtwnResponse;
import net.tokensmith.otter.dispatch.entity.RestErrorRequest;
import net.tokensmith.otter.dispatch.entity.RestErrorResponse;
import net.tokensmith.otter.dispatch.entity.either.RestReponseEither;
import net.tokensmith.otter.dispatch.entity.either.RestResponseError;
import net.tokensmith.otter.dispatch.exception.ClientException;
import net.tokensmith.otter.dispatch.exception.ServerException;
import net.tokensmith.otter.dispatch.translator.RestErrorHandler;
import net.tokensmith.otter.dispatch.translator.rest.RestBtwnRequestTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestBtwnResponseTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestErrorRequestTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestErrorResponseTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestRequestTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestResponseTranslator;
import net.tokensmith.otter.router.entity.Method;
import net.tokensmith.otter.router.entity.RestRoute;
import net.tokensmith.otter.router.entity.between.RestBetween;
import net.tokensmith.otter.router.entity.io.Answer;
import net.tokensmith.otter.router.entity.io.Ask;
import net.tokensmith.otter.router.exception.HaltException;
import net.tokensmith.otter.translator.JsonTranslator;
import net.tokensmith.otter.translator.exception.DeserializationException;
import net.tokensmith.otter.translator.exception.ToJsonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRouteRun<U extends DefaultUser, P>
implements RouteRunner {
    protected static Logger LOGGER = LoggerFactory.getLogger(JsonRouteRun.class);
    private RestRoute<U, P> restRoute;
    private RestResponseTranslator<P> restResponseTranslator;
    private RestRequestTranslator<U, P> restRequestTranslator;
    private RestBtwnRequestTranslator<U, P> restBtwnRequestTranslator;
    private RestBtwnResponseTranslator<P> restBtwnResponseTranslator;
    private JsonTranslator<P> jsonTranslator;
    private Map<StatusCode, RestErrorHandler<U>> errorHandlers;
    private RestErrorRequestTranslator<U> errorRequestTranslator;
    private RestErrorResponseTranslator errorResponseTranslator;

    public JsonRouteRun() {
    }

    public JsonRouteRun(RestRoute<U, P> restRoute, RestResponseTranslator<P> restResponseTranslator, RestRequestTranslator<U, P> restRequestTranslator, RestBtwnRequestTranslator<U, P> restBtwnRequestTranslator, RestBtwnResponseTranslator<P> restBtwnResponseTranslator, JsonTranslator<P> jsonTranslator, Map<StatusCode, RestErrorHandler<U>> errorHandlers, RestErrorRequestTranslator<U> errorRequestTranslator, RestErrorResponseTranslator errorResponseTranslator) {
        this.restRoute = restRoute;
        this.restResponseTranslator = restResponseTranslator;
        this.restRequestTranslator = restRequestTranslator;
        this.restBtwnRequestTranslator = restBtwnRequestTranslator;
        this.restBtwnResponseTranslator = restBtwnResponseTranslator;
        this.jsonTranslator = jsonTranslator;
        this.errorHandlers = errorHandlers;
        this.errorRequestTranslator = errorRequestTranslator;
        this.errorResponseTranslator = errorResponseTranslator;
    }

    @Override
    public Answer run(Ask ask, Answer answer) throws HaltException {
        answer = this.process(ask, answer);
        return answer;
    }

    protected Answer process(Ask ask, Answer answer) throws HaltException {
        Optional<P> entity;
        try {
            entity = this.to(ask.getBody());
        }
        catch (DeserializationException e) {
            ClientException clientException = new ClientException("Could not serialize request body", e);
            RestResponseError error = new RestResponseErrorBuilder().cause(clientException).errorType(RestResponseError.ErrorType.BAD_REQUEST).build();
            return this.handleErrors(error, ask, answer);
        }
        RestBtwnRequest<U> btwnRequest = this.restBtwnRequestTranslator.to(ask);
        RestBtwnResponse btwnResponse = this.restBtwnResponseTranslator.to(answer);
        RestReponseEither<U, P> runResponse = this.executeResourceMethod(this.restRoute, btwnRequest, btwnResponse, entity);
        if (runResponse.getRight().isPresent()) {
            answer = this.handleErrors(runResponse.getRight().get(), ask, answer);
        } else if (runResponse.getLeft().isPresent() && runResponse.getLeft().get().getRawPayload().isPresent()) {
            LOGGER.debug("using raw payload");
            answer = this.restResponseTranslator.from(answer, runResponse.getLeft().get());
            answer.setPayload(runResponse.getLeft().get().getRawPayload());
        } else {
            LOGGER.debug("using typed payload");
            answer = this.restResponseTranslator.from(answer, runResponse.getLeft().get());
            Optional<byte[]> out = this.payloadToBytes(runResponse.getLeft().get().getPayload());
            answer.setPayload(out);
        }
        return answer;
    }

    protected Optional<P> to(Optional<byte[]> body) throws DeserializationException {
        return this.makeEntity(body);
    }

    protected Optional<P> makeEntity(Optional<byte[]> body) throws DeserializationException {
        Optional<Object> entity = Optional.empty();
        if (body.isPresent()) {
            entity = Optional.of(this.jsonTranslator.from(body.get()));
        }
        return entity;
    }

    protected Answer handleErrors(RestResponseError<U, P> error, Ask ask, Answer answer) throws HaltException {
        RestResponseError.ErrorType errorType = error.getErrorType();
        if (RestResponseError.ErrorType.HALT.equals((Object)errorType)) {
            answer = this.restBtwnResponseTranslator.from(answer, error.getBtwnResponse());
            throw (HaltException)error.getCause();
        }
        if (RestResponseError.ErrorType.BAD_REQUEST.equals((Object)errorType)) {
            Optional<Answer> answerFromHandler = this.handle(StatusCode.BAD_REQUEST, error.getCause(), ask, answer);
            answer = answerFromHandler.get();
        } else if (RestResponseError.ErrorType.SERVER.equals((Object)errorType)) {
            answer = this.handleServerError(error.getCause(), ask, answer);
        }
        return answer;
    }

    protected Optional<Answer> handle(StatusCode statusCode, Throwable cause, Ask ask, Answer answer) {
        Optional<Answer> answerFromHandler = Optional.empty();
        RestErrorHandler<U> errorHandler = this.errorHandlers.get((Object)statusCode);
        if (errorHandler != null) {
            RestErrorRequest<U> errorReq = this.errorRequestTranslator.to(ask);
            RestErrorResponse errorResp = this.errorResponseTranslator.to(answer);
            answerFromHandler = Optional.of(errorHandler.run(errorReq, errorResp, cause));
        }
        return answerFromHandler;
    }

    protected Answer handleServerError(Throwable cause, Ask ask, Answer answer) throws HaltException {
        Optional<Answer> answerFromHandler = this.handle(StatusCode.SERVER_ERROR, cause, ask, answer);
        if (!answerFromHandler.isPresent()) {
            throw new HaltException(cause.getMessage(), cause);
        }
        return answerFromHandler.get();
    }

    protected RestReponseEither<U, P> executeResourceMethod(RestRoute<U, P> route, RestBtwnRequest<U> btwnRequest, RestBtwnResponse btwnResponse, Optional<P> entity) {
        RestReponseEither responseEither = new RestReponseEither();
        RestResponseErrorBuilder errorBuilder = new RestResponseErrorBuilder();
        RestRequest<U, P> requestForResource = null;
        RestResponse<P> responseForResource = null;
        RestResponse<P> resourceResponse = null;
        RestResponse<P> response = null;
        try {
            RestResource<U, P> resource = route.getRestResource();
            Method method = btwnRequest.getMethod();
            this.executeBetween(route.getBefore(), method, btwnRequest, btwnResponse);
            requestForResource = this.restRequestTranslator.to(btwnRequest, entity);
            responseForResource = this.restResponseTranslator.to(btwnResponse);
            resourceResponse = this.execute(method, resource, requestForResource, responseForResource);
            RestBtwnRequest<U> btwnRequestForAfter = this.restBtwnRequestTranslator.to(requestForResource);
            Optional<byte[]> resourceResponsePayload = this.payloadToBytes(resourceResponse.getPayload());
            RestBtwnResponse btwnResponseForAfter = this.restBtwnResponseTranslator.to(resourceResponse, resourceResponsePayload);
            this.executeBetween(route.getAfter(), method, btwnRequestForAfter, btwnResponseForAfter);
            response = this.restResponseTranslator.to(btwnResponseForAfter);
            this.setResponsePayload(resourceResponsePayload, btwnResponseForAfter.getPayload(), resourceResponse, response);
        }
        catch (HaltException e) {
            errorBuilder = errorBuilder.cause(e).errorType(RestResponseError.ErrorType.HALT);
        }
        catch (DeserializationException e) {
            ServerException cause = new ServerException("", e);
            errorBuilder = errorBuilder.cause(cause).errorType(RestResponseError.ErrorType.SERVER);
        }
        catch (Throwable e) {
            ServerException cause = new ServerException("", e);
            errorBuilder = errorBuilder.cause(cause).errorType(RestResponseError.ErrorType.SERVER);
        }
        RestResponseError error = errorBuilder.btwnRequest(btwnRequest).btwnResponse(btwnResponse).requestForResource(requestForResource).responseForResource(responseForResource).resourceResponse(resourceResponse).response(response).build();
        responseEither.setRight(error.getCause() == null ? Optional.empty() : Optional.of(error));
        responseEither.setLeft(error.getCause() == null ? Optional.of(response) : Optional.empty());
        return responseEither;
    }

    protected RestResponse<P> execute(Method method, RestResource<U, P> resource, RestRequest<U, P> request, RestResponse<P> response) {
        RestResponse<P> resourceResponse = null;
        if (method == Method.GET) {
            resourceResponse = resource.get(request, response);
        } else if (method == Method.POST) {
            resourceResponse = resource.post(request, response);
        } else if (method == Method.PUT) {
            resourceResponse = resource.put(request, response);
        } else if (method == Method.PATCH) {
            resourceResponse = resource.patch(request, response);
        } else if (method == Method.DELETE) {
            resourceResponse = resource.delete(request, response);
        } else if (method == Method.CONNECT) {
            resourceResponse = resource.connect(request, response);
        } else if (method == Method.OPTIONS) {
            resourceResponse = resource.options(request, response);
        } else if (method == Method.TRACE) {
            resourceResponse = resource.trace(request, response);
        } else if (method == Method.HEAD) {
            resourceResponse = resource.head(request, response);
        }
        return resourceResponse;
    }

    protected void setResponsePayload(Optional<byte[]> payload, Optional<byte[]> afterPayload, RestResponse<P> resourceResponse, RestResponse<P> response) throws DeserializationException {
        if (this.isPayloadDirty(payload, afterPayload)) {
            Optional<P> responseEntity = this.makeEntity(afterPayload);
            response.setPayload(responseEntity);
        } else {
            response.setPayload(resourceResponse.getPayload());
        }
    }

    protected boolean isPayloadDirty(Optional<byte[]> resourcePayload, Optional<byte[]> btwnPayload) {
        boolean isDirty = false;
        if (!resourcePayload.isPresent() && btwnPayload.isPresent()) {
            isDirty = true;
        } else if (resourcePayload.isPresent() && btwnPayload.isPresent() && !Arrays.equals(resourcePayload.get(), btwnPayload.get())) {
            isDirty = true;
        }
        return isDirty;
    }

    protected void executeBetween(List<RestBetween<U>> betweens, Method method, RestBtwnRequest<U> btwnRequest, RestBtwnResponse btwnResponse) throws HaltException {
        for (RestBetween<U> between : betweens) {
            between.process(method, btwnRequest, btwnResponse);
        }
    }

    protected Optional<byte[]> payloadToBytes(Optional<P> payload) {
        Optional<byte[]> out = Optional.empty();
        if (payload.isPresent()) {
            try {
                out = Optional.of(this.jsonTranslator.to(payload.get()));
            }
            catch (ToJsonException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return out;
    }

    public RestRoute<U, P> getRestRoute() {
        return this.restRoute;
    }
}

