/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.dispatch.html;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.tokensmith.otter.controller.Resource;
import net.tokensmith.otter.controller.entity.DefaultSession;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.controller.entity.StatusCode;
import net.tokensmith.otter.controller.entity.request.Request;
import net.tokensmith.otter.controller.entity.response.Response;
import net.tokensmith.otter.dispatch.RouteRunner;
import net.tokensmith.otter.dispatch.builder.ResponseErrorBuilder;
import net.tokensmith.otter.dispatch.entity.either.ResponseEither;
import net.tokensmith.otter.dispatch.entity.either.ResponseError;
import net.tokensmith.otter.dispatch.translator.AnswerTranslator;
import net.tokensmith.otter.dispatch.translator.RequestTranslator;
import net.tokensmith.otter.router.entity.Method;
import net.tokensmith.otter.router.entity.Route;
import net.tokensmith.otter.router.entity.between.Between;
import net.tokensmith.otter.router.entity.io.Answer;
import net.tokensmith.otter.router.entity.io.Ask;
import net.tokensmith.otter.router.exception.HaltException;

public class RouteRun<S extends DefaultSession, U extends DefaultUser>
implements RouteRunner {
    private Route<S, U> route;
    private RequestTranslator<S, U> requestTranslator;
    private AnswerTranslator<S> answerTranslator;
    private Map<StatusCode, Resource<S, U>> errorResources;

    public RouteRun(Route<S, U> route, RequestTranslator<S, U> requestTranslator, AnswerTranslator<S> answerTranslator, Map<StatusCode, Resource<S, U>> errorResources) {
        this.route = route;
        this.requestTranslator = requestTranslator;
        this.answerTranslator = answerTranslator;
        this.errorResources = errorResources;
    }

    @Override
    public Answer run(Ask ask, Answer answer) throws HaltException {
        answer = this.process(ask, answer);
        return answer;
    }

    protected Answer process(Ask ask, Answer answer) throws HaltException {
        Response<S> response;
        Request<S, U> request = this.requestTranslator.to(ask);
        ResponseEither<S, U> runResponseEither = this.executeResourceMethod(this.route, request, response = this.answerTranslator.from(answer));
        answer = runResponseEither.getRight().isPresent() ? this.handleErrors(runResponseEither.getRight().get(), ask, answer) : this.answerTranslator.to(runResponseEither.getLeft().get());
        return answer;
    }

    protected Answer handleErrors(ResponseError<S, U> error, Ask ask, Answer answer) throws HaltException {
        ResponseError.ErrorType errorType = error.getErrorType();
        if (ResponseError.ErrorType.HALT.equals((Object)errorType)) {
            answer = this.answerTranslator.to(answer, error.getResponse());
            throw (HaltException)error.getCause();
        }
        if (ResponseError.ErrorType.SERVER.equals((Object)errorType)) {
            Optional<Answer> answerFromErrorResource = this.handle(StatusCode.SERVER_ERROR, error.getCause(), ask, answer);
            if (!answerFromErrorResource.isPresent()) {
                throw new HaltException(error.getCause().getMessage(), error.getCause());
            }
            answer = answerFromErrorResource.get();
        }
        return answer;
    }

    protected Optional<Answer> handle(StatusCode statusCode, Throwable cause, Ask ask, Answer answer) {
        Optional<Answer> answerFromErrorResource = Optional.empty();
        Resource<S, U> errorResource = this.errorResources.get((Object)statusCode);
        if (errorResource != null) {
            Request<S, U> request = this.requestTranslator.to(ask);
            Response<S> response = this.answerTranslator.from(answer);
            Method method = request.getMethod();
            Response<S> responseFromErrorResource = null;
            if (method == Method.GET) {
                responseFromErrorResource = errorResource.get(request, response);
            } else if (method == Method.POST) {
                responseFromErrorResource = errorResource.post(request, response);
            } else if (method == Method.PUT) {
                responseFromErrorResource = errorResource.put(request, response);
            } else if (method == Method.PATCH) {
                responseFromErrorResource = errorResource.patch(request, response);
            } else if (method == Method.DELETE) {
                responseFromErrorResource = errorResource.delete(request, response);
            } else if (method == Method.CONNECT) {
                responseFromErrorResource = errorResource.connect(request, response);
            } else if (method == Method.OPTIONS) {
                responseFromErrorResource = errorResource.options(request, response);
            } else if (method == Method.TRACE) {
                responseFromErrorResource = errorResource.trace(request, response);
            } else if (method == Method.HEAD) {
                responseFromErrorResource = errorResource.head(request, response);
            }
            answerFromErrorResource = Optional.of(this.answerTranslator.to(answer, responseFromErrorResource));
        }
        return answerFromErrorResource;
    }

    protected ResponseEither<S, U> executeResourceMethod(Route<S, U> route, Request<S, U> request, Response<S> response) {
        ResponseEither responseEither = new ResponseEither();
        ResponseErrorBuilder<S, U> errorBuilder = new ResponseErrorBuilder<S, U>();
        Resource<S, U> resource = route.getResource();
        Method method = request.getMethod();
        try {
            this.executeBetween(route.getBefore(), method, request, response);
            Response<S> resourceResponse = this.execute(method, resource, request, response);
            this.executeBetween(route.getAfter(), method, request, resourceResponse);
        }
        catch (HaltException e) {
            errorBuilder = errorBuilder.cause(e).errorType(ResponseError.ErrorType.HALT);
        }
        catch (Throwable e) {
            errorBuilder = errorBuilder.cause(e).errorType(ResponseError.ErrorType.SERVER);
        }
        ResponseError error = errorBuilder.request(request).response(response).build();
        responseEither.setRight(error.getCause() == null ? Optional.empty() : Optional.of(error));
        responseEither.setLeft(error.getCause() == null ? Optional.of(response) : Optional.empty());
        return responseEither;
    }

    protected Response<S> execute(Method method, Resource<S, U> resource, Request<S, U> request, Response<S> response) {
        Response<S> resourceResponse = null;
        if (method == Method.GET) {
            resourceResponse = resource.get(request, response);
        } else if (method == Method.POST) {
            resourceResponse = resource.post(request, response);
        } else if (method == Method.PUT) {
            resourceResponse = resource.put(request, response);
        } else if (method == Method.PATCH) {
            resourceResponse = resource.patch(request, response);
        } else if (method == Method.DELETE) {
            resourceResponse = resource.delete(request, response);
        } else if (method == Method.CONNECT) {
            resourceResponse = resource.connect(request, response);
        } else if (method == Method.OPTIONS) {
            resourceResponse = resource.options(request, response);
        } else if (method == Method.TRACE) {
            resourceResponse = resource.trace(request, response);
        } else if (method == Method.HEAD) {
            resourceResponse = resource.head(request, response);
        }
        return resourceResponse;
    }

    protected void executeBetween(List<Between<S, U>> betweens, Method method, Request<S, U> request, Response<S> response) throws HaltException {
        for (Between<S, U> between : betweens) {
            between.process(method, request, response);
        }
    }

    public Route<S, U> getRoute() {
        return this.route;
    }

    public RequestTranslator<S, U> getRequestTranslator() {
        return this.requestTranslator;
    }

    public AnswerTranslator<S> getAnswerTranslator() {
        return this.answerTranslator;
    }
}

