/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.dispatch.config;

import java.util.HashMap;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.dispatch.RouteRunner;
import net.tokensmith.otter.dispatch.json.JsonDispatchErrorRouteRun;
import net.tokensmith.otter.dispatch.json.JsonErrorHandler;
import net.tokensmith.otter.dispatch.translator.RestErrorHandler;
import net.tokensmith.otter.dispatch.translator.rest.RestBtwnRequestTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestBtwnResponseTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestErrorRequestTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestErrorResponseTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestRequestTranslator;
import net.tokensmith.otter.dispatch.translator.rest.RestResponseTranslator;
import net.tokensmith.otter.gateway.entity.rest.RestError;
import net.tokensmith.otter.gateway.entity.rest.RestErrorTarget;
import net.tokensmith.otter.router.builder.RestRouteBuilder;
import net.tokensmith.otter.router.entity.RestRoute;
import net.tokensmith.otter.translatable.Translatable;
import net.tokensmith.otter.translator.JsonTranslator;
import net.tokensmith.otter.translator.config.TranslatorAppFactory;

public class DispatchAppFactory {
    private static TranslatorAppFactory translatorAppFactory = new TranslatorAppFactory();

    public <U extends DefaultUser, P extends Translatable> RestRoute<U, ? extends Translatable> makeRestRoute(RestErrorTarget<U, P> from) {
        return new RestRouteBuilder<U, P>().restResource(from.getResource()).before(from.getBefore()).after(from.getAfter()).build();
    }

    public <U extends DefaultUser, P extends Translatable> RouteRunner makeJsonDispatchErrorRouteRun(RestRoute<U, ? extends Translatable> restRoute, Class<? extends Translatable> payload) {
        Class<P> castedPayload = this.toPayload(payload);
        JsonTranslator<P> jsonTranslator = translatorAppFactory.jsonTranslator(castedPayload);
        RestRequestTranslator restRequestTranslator = new RestRequestTranslator();
        RestResponseTranslator restResponseTranslator = new RestResponseTranslator();
        RestBtwnRequestTranslator restBtwnRequestTranslator = new RestBtwnRequestTranslator();
        RestBtwnResponseTranslator restBtwnResponseTranslator = new RestBtwnResponseTranslator();
        RestRoute castedRestRoute = this.toRestRoute(restRoute);
        return new JsonDispatchErrorRouteRun(castedRestRoute, restResponseTranslator, restRequestTranslator, restBtwnRequestTranslator, restBtwnResponseTranslator, jsonTranslator, new HashMap(), new RestErrorRequestTranslator(), new RestErrorResponseTranslator());
    }

    protected <P extends Translatable> Class<P> toPayload(Class<? extends Translatable> from) {
        return from;
    }

    protected <U extends DefaultUser, E extends Translatable> RestRoute<U, E> toRestRoute(RestRoute<U, ? extends Translatable> from) {
        return from;
    }

    public <U extends DefaultUser, P extends Translatable> RestErrorHandler<U> restErrorHandler(RestError<U, ? extends P> restError) {
        RestError<U, P> castedRestErrorValue = this.toRestError(restError);
        JsonTranslator<? extends P> jsonTranslator = translatorAppFactory.jsonTranslator(castedRestErrorValue.getPayload());
        return new JsonErrorHandler<U, P>(jsonTranslator, castedRestErrorValue.getRestResource(), new RestRequestTranslator(), new RestResponseTranslator());
    }

    public <U extends DefaultUser, P extends Translatable> RestError<U, P> toRestError(RestError<U, ? extends P> restError) {
        return restError;
    }
}

