/*
 * Decompiled with CFR 0.152.
 */
package net.tokensmith.otter.config;

import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.tokensmith.otter.QueryStringToMap;
import net.tokensmith.otter.controller.entity.ClientError;
import net.tokensmith.otter.controller.entity.DefaultSession;
import net.tokensmith.otter.controller.entity.DefaultUser;
import net.tokensmith.otter.controller.entity.ServerError;
import net.tokensmith.otter.controller.entity.StatusCode;
import net.tokensmith.otter.controller.error.rest.BadRequestRestResource;
import net.tokensmith.otter.controller.error.rest.MediaTypeRestResource;
import net.tokensmith.otter.controller.error.rest.NotAcceptableRestResource;
import net.tokensmith.otter.controller.error.rest.ServerErrorRestResource;
import net.tokensmith.otter.gateway.LocationTranslatorFactory;
import net.tokensmith.otter.gateway.RestLocationTranslatorFactory;
import net.tokensmith.otter.gateway.entity.Group;
import net.tokensmith.otter.gateway.entity.Shape;
import net.tokensmith.otter.gateway.entity.rest.RestError;
import net.tokensmith.otter.gateway.entity.rest.RestErrorTarget;
import net.tokensmith.otter.gateway.entity.rest.RestGroup;
import net.tokensmith.otter.gateway.servlet.ServletGateway;
import net.tokensmith.otter.gateway.servlet.merger.HttpServletRequestMerger;
import net.tokensmith.otter.gateway.servlet.merger.HttpServletResponseMerger;
import net.tokensmith.otter.gateway.servlet.translator.HttpServletRequestCookieTranslator;
import net.tokensmith.otter.gateway.servlet.translator.HttpServletRequestHeaderTranslator;
import net.tokensmith.otter.gateway.servlet.translator.HttpServletRequestTranslator;
import net.tokensmith.otter.gateway.translator.LocationTranslator;
import net.tokensmith.otter.gateway.translator.RestLocationTranslator;
import net.tokensmith.otter.router.Dispatcher;
import net.tokensmith.otter.router.Engine;
import net.tokensmith.otter.security.exception.SessionCtorException;
import net.tokensmith.otter.server.container.ServletContainerFactory;
import net.tokensmith.otter.server.path.CompiledClassPath;
import net.tokensmith.otter.server.path.WebAppPath;
import net.tokensmith.otter.translatable.Translatable;
import net.tokensmith.otter.translator.MimeTypeTranslator;

public class OtterAppFactory {
    public static Integer WRITE_CHUNK_SIZE = 1024;

    public CompiledClassPath compiledClassPath() {
        return new CompiledClassPath();
    }

    public WebAppPath webAppPath() {
        return new WebAppPath();
    }

    public ServletContainerFactory servletContainerFactory() {
        return new ServletContainerFactory(this.compiledClassPath(), this.webAppPath());
    }

    public ServletGateway servletGateway(Shape shape, List<Group<? extends DefaultSession, ? extends DefaultUser>> groups, List<RestGroup<? extends DefaultUser>> restGroups) throws SessionCtorException {
        LocationTranslatorFactory locationTranslatorFactory = this.locationTranslatorFactory(shape);
        RestLocationTranslatorFactory restLocationTranslatorFactory = this.restLocationTranslatorFactory();
        Map<String, LocationTranslator<? extends DefaultSession, ? extends DefaultUser>> locationTranslators = this.locationTranslators(locationTranslatorFactory, groups);
        Map<String, RestLocationTranslator<? extends DefaultUser, ?>> restLocationTranslators = this.restLocationTranslators(restLocationTranslatorFactory, restGroups);
        Integer writeChunkSize = shape.getWriteChunkSize() != null ? shape.getWriteChunkSize() : WRITE_CHUNK_SIZE;
        return new ServletGateway(this.httpServletRequestTranslator(), this.httpServletRequestMerger(), this.httpServletResponseMerger(), this.engine(), locationTranslators, restLocationTranslators, writeChunkSize);
    }

    public Engine engine() {
        return new Engine(new Dispatcher(), new Dispatcher());
    }

    public LocationTranslatorFactory locationTranslatorFactory(Shape shape) {
        return new LocationTranslatorFactory(shape);
    }

    public <S extends DefaultSession, U extends DefaultUser> Map<String, LocationTranslator<? extends S, ? extends U>> locationTranslators(LocationTranslatorFactory locationTranslatorFactory, List<Group<? extends S, ? extends U>> groups) throws SessionCtorException {
        HashMap<String, LocationTranslator<S, U>> locationTranslators = new HashMap<String, LocationTranslator<S, U>>();
        Iterator<Group<S, U>> iterator = groups.iterator();
        while (iterator.hasNext()) {
            Group<S, U> group;
            Group<S, U> castedGroup = group = iterator.next();
            locationTranslators.put(group.getName(), locationTranslatorFactory.make(castedGroup.getSessionClazz(), castedGroup.getAuthRequired(), castedGroup.getAuthOptional(), castedGroup.getErrorResources(), castedGroup.getDispatchErrors(), new HashMap()));
        }
        return locationTranslators;
    }

    public RestLocationTranslatorFactory restLocationTranslatorFactory() {
        return new RestLocationTranslatorFactory();
    }

    public <U extends DefaultUser, P> Map<String, RestLocationTranslator<? extends U, ? extends P>> restLocationTranslators(RestLocationTranslatorFactory restLocationTranslatorFactory, List<RestGroup<? extends U>> restGroups) throws SessionCtorException {
        HashMap<String, RestLocationTranslator<U, P>> restLocationTranslators = new HashMap<String, RestLocationTranslator<U, P>>();
        Iterator<RestGroup<U>> iterator = restGroups.iterator();
        while (iterator.hasNext()) {
            RestGroup<U> restGroup;
            RestGroup<U> castedGroup = restGroup = iterator.next();
            restLocationTranslators.put(castedGroup.getName(), restLocationTranslatorFactory.make(castedGroup.getAuthRequired(), castedGroup.getAuthOptional(), castedGroup.getRestErrors(), this.defaultErrors(), castedGroup.getDispatchErrors(), this.defaultDispatchErrors()));
        }
        return restLocationTranslators;
    }

    public <U extends DefaultUser, P extends Translatable> Map<StatusCode, RestError<U, ? extends Translatable>> defaultErrors() {
        HashMap<StatusCode, RestError<U, Translatable>> defaultErrors = new HashMap<StatusCode, RestError<U, Translatable>>();
        RestError badRequest = new RestError(ClientError.class, new BadRequestRestResource());
        defaultErrors.put(StatusCode.BAD_REQUEST, badRequest);
        RestError serverError = new RestError(ServerError.class, new ServerErrorRestResource());
        defaultErrors.put(StatusCode.SERVER_ERROR, serverError);
        return defaultErrors;
    }

    public <U extends DefaultUser, P extends Translatable> Map<StatusCode, RestErrorTarget<U, ? extends Translatable>> defaultDispatchErrors() {
        HashMap<StatusCode, RestErrorTarget<U, Translatable>> defaultDispatchErrors = new HashMap<StatusCode, RestErrorTarget<U, Translatable>>();
        MediaTypeRestResource mediaType = new MediaTypeRestResource();
        RestErrorTarget mediaTypeTarget = new RestErrorTarget(ClientError.class, mediaType, new ArrayList(), new ArrayList());
        defaultDispatchErrors.put(StatusCode.UNSUPPORTED_MEDIA_TYPE, mediaTypeTarget);
        NotAcceptableRestResource notAcceptable = new NotAcceptableRestResource();
        RestErrorTarget notAcceptableTarget = new RestErrorTarget(ClientError.class, notAcceptable, new ArrayList(), new ArrayList());
        defaultDispatchErrors.put(StatusCode.NOT_ACCEPTABLE, notAcceptableTarget);
        return defaultDispatchErrors;
    }

    public HttpServletRequestTranslator httpServletRequestTranslator() {
        return new HttpServletRequestTranslator(this.httpServletRequestCookieTranslator(), new HttpServletRequestHeaderTranslator(), new QueryStringToMap(), new MimeTypeTranslator());
    }

    public HttpServletRequestMerger httpServletRequestMerger() {
        return new HttpServletRequestMerger();
    }

    public HttpServletResponseMerger httpServletResponseMerger() {
        return new HttpServletResponseMerger(this.httpServletRequestCookieTranslator());
    }

    public HttpServletRequestCookieTranslator httpServletRequestCookieTranslator() {
        return new HttpServletRequestCookieTranslator();
    }

    public Base64.Decoder urlDecoder() {
        return Base64.getUrlDecoder();
    }
}

