/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.base.BaseTabularFormatter;
import schemacrawler.tools.text.operation.DataResultSet;
import schemacrawler.tools.text.operation.Operation;
import schemacrawler.tools.text.operation.OperationOptions;
import schemacrawler.tools.text.utility.Alignment;
import schemacrawler.tools.text.utility.TextFormattingHelper;
import schemacrawler.tools.traversal.DataTraversalHandler;

final class DataTextFormatter
extends BaseTabularFormatter<OperationOptions>
implements DataTraversalHandler {
    private int dataBlockCount;
    private final Operation operation;

    DataTextFormatter(Operation operation, OperationOptions options, OutputOptions outputOptions) throws SchemaCrawlerException {
        super(options, false, outputOptions);
        this.operation = operation;
    }

    @Override
    public void end() throws SchemaCrawlerException {
        if (this.operation == Operation.count) {
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        super.end();
    }

    @Override
    public void handleData(String title, ResultSet rows) throws SchemaCrawlerException {
        if (this.dataBlockCount == 0) {
            this.printHeader();
        }
        if (this.operation == Operation.count) {
            this.handleAggregateOperationForTable(title, rows);
        } else {
            this.out.println(this.formattingHelper.createObjectStart(title));
            try {
                DataResultSet dataRows = new DataResultSet(rows, ((OperationOptions)this.options).isShowLobs());
                this.out.println(this.formattingHelper.createRowHeader(dataRows.getColumnNames()));
                this.iterateRows(dataRows);
            }
            catch (SQLException e) {
                throw new SchemaCrawlerException(e.getMessage(), (Throwable)e);
            }
            this.out.println(this.formattingHelper.createObjectEnd());
        }
        ++this.dataBlockCount;
    }

    private String getMessage(double aggregate) {
        Number number = Math.abs(aggregate - (double)((int)aggregate)) < 1.0E-10 ? (Number)((int)aggregate) : (Number)aggregate;
        String message = this.operation.getCountMessage(number);
        return message;
    }

    private void handleAggregateOperationForTable(String title, ResultSet results) throws SchemaCrawlerException {
        long aggregate = 0L;
        try {
            if (results.next()) {
                aggregate = results.getLong(1);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Could not obtain aggregate data", (Throwable)e);
        }
        String message = this.getMessage(aggregate);
        this.out.println(this.formattingHelper.createNameValueRow(title, message, Alignment.right));
    }

    private void iterateRows(DataResultSet dataRows) throws SQLException {
        while (dataRows.next()) {
            List<String> currentRow = dataRows.row();
            String[] columnData = currentRow.toArray(new String[currentRow.size()]);
            this.out.println(this.formattingHelper.createRow(columnData));
        }
    }

    private void printHeader() {
        if (this.operation != null) {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, this.operation.getDescription()));
        } else {
            this.out.println(this.formattingHelper.createHeader(TextFormattingHelper.DocumentHeaderType.subTitle, "Query"));
        }
        if (this.operation == Operation.count) {
            this.out.println(this.formattingHelper.createObjectStart(this.operation.getDescription()));
        }
    }
}

