/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.operation;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schema.ResultsColumn;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.utility.SchemaCrawlerUtility;
import sf.util.Utility;

final class DataResultSet {
    private static final Logger LOGGER = Logger.getLogger(DataResultSet.class.getName());
    private static final String NULL = "<null>";
    private static final String BINARY = "<binary>";
    private final ResultSet rows;
    private final List<ResultsColumn> resultsColumns;
    private final boolean showLobs;

    public DataResultSet(ResultSet rows, boolean showLobs) throws SchemaCrawlerException {
        try {
            if (rows == null || rows.isClosed() || rows.isAfterLast()) {
                throw new SchemaCrawlerException("Result set cannot be used");
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Result set cannot be used", (Throwable)e);
        }
        this.rows = rows;
        this.showLobs = showLobs;
        this.resultsColumns = SchemaCrawlerUtility.getResultColumns((ResultSet)rows).getColumns();
    }

    public String[] getColumnNames() {
        int columnCount = this.resultsColumns.size();
        String[] columnNames = new String[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            columnNames[i] = this.resultsColumns.get(i).getName();
        }
        return columnNames;
    }

    public boolean next() throws SQLException {
        return this.rows.next();
    }

    public List<String> row() throws SQLException {
        int columnCount = this.resultsColumns.size();
        ArrayList<String> currentRow = new ArrayList<String>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            String columnDataString = this.convertColumnDataToString(i);
            currentRow.add(columnDataString);
        }
        return currentRow;
    }

    public int width() {
        return this.resultsColumns.size();
    }

    private String convertColumnDataToString(int i) throws SQLException {
        String columnDataString;
        int javaSqlType = this.resultsColumns.get(i).getType().getType();
        if (javaSqlType == 2005) {
            Clob clob = this.rows.getClob(i + 1);
            columnDataString = this.rows.wasNull() || clob == null ? NULL : this.readClob(clob);
        } else if (javaSqlType == 2007) {
            NClob nClob = this.rows.getNClob(i + 1);
            columnDataString = this.rows.wasNull() || nClob == null ? NULL : this.readClob(nClob);
        } else if (javaSqlType == 2004) {
            Blob blob = this.rows.getBlob(i + 1);
            columnDataString = this.rows.wasNull() || blob == null ? NULL : this.readBlob(blob);
        } else if (javaSqlType == -4) {
            InputStream stream = this.rows.getBinaryStream(i + 1);
            columnDataString = this.rows.wasNull() || stream == null ? NULL : this.readStream(stream);
        } else if (javaSqlType == -10 || javaSqlType == -1) {
            InputStream stream = this.rows.getAsciiStream(i + 1);
            columnDataString = this.rows.wasNull() || stream == null ? NULL : this.readStream(stream);
        } else {
            Object columnData = this.rows.getObject(i + 1);
            columnDataString = this.rows.wasNull() || columnData == null ? NULL : columnData.toString();
        }
        return columnDataString;
    }

    private String readBlob(Blob blob) {
        if (blob == null) {
            return NULL;
        }
        if (this.showLobs) {
            String lobData;
            InputStream in = null;
            try {
                try {
                    in = blob.getBinaryStream();
                }
                catch (SQLFeatureNotSupportedException e) {
                    in = null;
                }
                lobData = in != null ? Utility.readFully((InputStream)in) : BINARY;
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read BLOB data", e);
                lobData = BINARY;
            }
            return lobData;
        }
        return BINARY;
    }

    private String readClob(Clob clob) {
        if (clob == null) {
            return NULL;
        }
        if (this.showLobs) {
            String lobData;
            Reader rdr = null;
            try {
                try {
                    rdr = clob.getCharacterStream();
                }
                catch (SQLFeatureNotSupportedException e) {
                    rdr = null;
                }
                if (rdr == null) {
                    try {
                        rdr = new InputStreamReader(clob.getAsciiStream());
                    }
                    catch (SQLFeatureNotSupportedException e) {
                        rdr = null;
                    }
                }
                if (rdr != null) {
                    lobData = Utility.readFully((Reader)rdr);
                    if (lobData.length() == 0) {
                        long clobLength = clob.length();
                        lobData = clob.getSubString(1L, (int)clobLength);
                    }
                } else {
                    lobData = BINARY;
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, "Could not read CLOB data", e);
                lobData = BINARY;
            }
            return lobData;
        }
        return BINARY;
    }

    private String readStream(InputStream stream) {
        if (stream == null) {
            return NULL;
        }
        if (this.showLobs) {
            BufferedInputStream in = new BufferedInputStream(stream);
            String lobData = Utility.readFully((InputStream)in);
            return lobData;
        }
        return BINARY;
    }
}

