/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline;

import java.sql.Connection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.Config;
import schemacrawler.schemacrawler.ConnectionOptions;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.tools.commandline.AdditionalConfigParser;
import schemacrawler.tools.commandline.BundledDriverConnectionOptionsParser;
import schemacrawler.tools.commandline.CommandLine;
import schemacrawler.tools.commandline.CommandLineConnectionOptionsParser;
import schemacrawler.tools.commandline.CommandParser;
import schemacrawler.tools.commandline.ConfigParser;
import schemacrawler.tools.commandline.OutputOptionsParser;
import schemacrawler.tools.commandline.SchemaCrawlerOptionsParser;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputOptions;
import sf.util.ObjectToString;

public final class SchemaCrawlerCommandLine
implements CommandLine {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerCommandLine.class.getName());
    private final String command;
    private final Config config;
    private final SchemaCrawlerOptions schemaCrawlerOptions;
    private final OutputOptions outputOptions;
    private final ConnectionOptions connectionOptions;

    public SchemaCrawlerCommandLine(Config config, String ... args) throws SchemaCrawlerException {
        this(config, (ConnectionOptions)null, args);
    }

    public SchemaCrawlerCommandLine(ConnectionOptions connectionOptions, String ... args) throws SchemaCrawlerException {
        this(null, connectionOptions, args);
    }

    private SchemaCrawlerCommandLine(Config providedConfig, ConnectionOptions connectionOptions, String ... args) throws SchemaCrawlerException {
        if (args == null || args.length == 0) {
            throw new SchemaCrawlerException("No command line arguments provided");
        }
        String[] remainingArgs = args;
        CommandParser commandParser = new CommandParser();
        remainingArgs = commandParser.parse(remainingArgs);
        if (!commandParser.hasOptions()) {
            throw new SchemaCrawlerException("No command specified");
        }
        this.command = commandParser.getOptions().toString();
        OutputOptionsParser outputOptionsParser = new OutputOptionsParser();
        remainingArgs = outputOptionsParser.parse(remainingArgs);
        this.outputOptions = outputOptionsParser.getOptions();
        boolean isBundledWithDriver = providedConfig != null;
        this.config = isBundledWithDriver ? providedConfig : new Config();
        if (remainingArgs.length > 0) {
            ConfigParser configParser = new ConfigParser();
            remainingArgs = configParser.parse(remainingArgs);
            this.config.putAll((Map)configParser.getOptions());
        }
        if (remainingArgs.length > 0) {
            AdditionalConfigParser additionalConfigParser = new AdditionalConfigParser();
            remainingArgs = additionalConfigParser.parse(remainingArgs);
            this.config.putAll((Map)additionalConfigParser.getOptions());
        }
        if (connectionOptions != null) {
            this.connectionOptions = connectionOptions;
        } else if (isBundledWithDriver) {
            BundledDriverConnectionOptionsParser bundledDriverConnectionOptionsParser = new BundledDriverConnectionOptionsParser(this.config);
            remainingArgs = bundledDriverConnectionOptionsParser.parse(remainingArgs);
            this.connectionOptions = (ConnectionOptions)bundledDriverConnectionOptionsParser.getOptions();
        } else {
            CommandLineConnectionOptionsParser commandLineConnectionOptionsParser = new CommandLineConnectionOptionsParser(this.config);
            remainingArgs = commandLineConnectionOptionsParser.parse(remainingArgs);
            this.connectionOptions = commandLineConnectionOptionsParser.getOptions();
        }
        SchemaCrawlerOptionsParser schemaCrawlerOptionsParser = new SchemaCrawlerOptionsParser(this.config);
        remainingArgs = schemaCrawlerOptionsParser.parse(remainingArgs);
        this.schemaCrawlerOptions = schemaCrawlerOptionsParser.getOptions();
        if (remainingArgs.length > 0) {
            LOGGER.log(Level.INFO, "Too many command line arguments provided: " + ObjectToString.toString((Object)remainingArgs));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws Exception {
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable(this.command);
        if (this.outputOptions != null) {
            executable.setOutputOptions(this.outputOptions);
        }
        if (this.schemaCrawlerOptions != null) {
            executable.setSchemaCrawlerOptions(this.schemaCrawlerOptions);
        }
        if (this.config != null) {
            executable.setAdditionalConfiguration(this.config);
        }
        if (this.connectionOptions != null) {
            Connection connection = null;
            try {
                connection = this.connectionOptions.getConnection();
                LOGGER.log(Level.INFO, "Made connection, " + connection);
                executable.execute(connection);
            }
            finally {
                if (connection != null) {
                    connection.close();
                    LOGGER.log(Level.INFO, "Closed connection, " + connection);
                }
            }
        } else {
            throw new SchemaCrawlerException("No connection options provided");
        }
    }

    public final String getCommand() {
        return this.command;
    }

    public final Config getConfig() {
        return this.config;
    }

    public final ConnectionOptions getConnectionOptions() {
        return this.connectionOptions;
    }

    public final OutputOptions getOutputOptions() {
        return this.outputOptions;
    }

    public final SchemaCrawlerOptions getSchemaCrawlerOptions() {
        return this.schemaCrawlerOptions;
    }
}

