/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaViews;

final class SchemaRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(SchemaRetriever.class.getName());
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;

    SchemaRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
        this.supportsCatalogs = retrieverConnection.isSupportsCatalogs();
        this.supportsSchemas = retrieverConnection.isSupportsSchemas();
    }

    void retrieveSchemas(InclusionRule schemaInclusionRule) throws SQLException {
        Set<SchemaReference> schemaRefs = this.retrieveAllSchemasFromInformationSchemaViews();
        if (schemaRefs.isEmpty()) {
            schemaRefs.addAll(this.retrieveAllSchemas());
        }
        Iterator<SchemaReference> iterator = schemaRefs.iterator();
        while (iterator.hasNext()) {
            SchemaReference schemaRef = iterator.next();
            String schemaFullName = schemaRef.getFullName();
            if (schemaInclusionRule == null || schemaFullName == null || schemaInclusionRule.include(schemaFullName)) continue;
            LOGGER.log(Level.FINER, "Dropping schema, since schema is excluded: " + schemaRef.getFullName());
            iterator.remove();
        }
        for (SchemaReference schemaRef : schemaRefs) {
            this.database.addSchema(schemaRef);
        }
        if (!this.supportsCatalogs && !this.supportsSchemas) {
            this.database.addSchema(new SchemaReference(null, null));
        }
    }

    private Set<String> retrieveAllCatalogs() {
        HashSet<String> catalogNames = new HashSet<String>();
        if (this.supportsCatalogs) {
            try {
                List<String> metaDataCatalogNames = SchemaRetriever.readResultsVector(this.getMetaData().getCatalogs());
                for (String catalogName : metaDataCatalogNames) {
                    catalogNames.add(this.quotedName(catalogName));
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            LOGGER.log(Level.FINER, "Retrieved catalogs: " + catalogNames);
        }
        return catalogNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Set<SchemaReference> retrieveAllSchemas() throws SQLException {
        block7: {
            schemaRefs = new HashSet<SchemaReference>();
            allCatalogNames = this.retrieveAllCatalogs();
            if (!this.supportsSchemas) break block7;
            results = new MetadataResultSet(this.getMetaData().getSchemas());
lbl5:
            // 2 sources

            try {
                while (results.next()) {
                    block8: {
                        catalogName = this.supportsCatalogs != false ? this.quotedName(results.getString("TABLE_CATALOG")) : null;
                        schemaName = this.quotedName(results.getString("TABLE_SCHEM"));
                        SchemaRetriever.LOGGER.log(Level.FINER, String.format("Retrieving schema: %s --> %s", new Object[]{catalogName, schemaName}));
                        if (catalogName != null) break block8;
                        if (allCatalogNames.isEmpty()) {
                            schemaRefs.add(new SchemaReference(null, schemaName));
                            continue;
                        }
                        for (String expectedCatalogName : allCatalogNames) {
                            schemaRefs.add(new SchemaReference(expectedCatalogName, schemaName));
                        }
                        ** GOTO lbl5
                    }
                    schemaRefs.add(new SchemaReference(catalogName, schemaName));
                }
            }
            finally {
                results.close();
            }
        }
        for (String catalogName : allCatalogNames) {
            SchemaRetriever.LOGGER.log(Level.FINER, String.format("Retrieving schema: %s --> %s", new Object[]{catalogName, null}));
            schemaRefs.add(new SchemaReference(catalogName, null));
        }
        return schemaRefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<SchemaReference> retrieveAllSchemasFromInformationSchemaViews() throws SQLException {
        HashSet<SchemaReference> schemaRefs = new HashSet<SchemaReference>();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasSchemataSql()) {
            LOGGER.log(Level.FINE, "Schemata SQL statement was not provided");
            return schemaRefs;
        }
        String schemataSql = informationSchemaViews.getSchemataSql();
        Connection connection = this.getDatabaseConnection();
        Statement statement = connection.createStatement();
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(statement.executeQuery(schemataSql));
            while (results.next()) {
                String catalogName = this.quotedName(results.getString("CATALOG_NAME"));
                String schemaName = this.quotedName(results.getString("SCHEMA_NAME"));
                LOGGER.log(Level.FINER, String.format("Retrieving schema: %s --> %s", catalogName, schemaName));
                schemaRefs.add(new SchemaReference(catalogName, schemaName));
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve schemas", e);
        }
        finally {
            if (results != null) {
                results.close();
            }
            statement.close();
        }
        return schemaRefs;
    }
}

