/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableDatabase;
import schemacrawler.crawl.MutableFunction;
import schemacrawler.crawl.MutableFunctionColumn;
import schemacrawler.crawl.MutableProcedure;
import schemacrawler.crawl.MutableProcedureColumn;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.FunctionColumnType;
import schemacrawler.schema.FunctionReturnType;
import schemacrawler.schema.ProcedureColumnType;
import schemacrawler.schema.ProcedureReturnType;
import schemacrawler.schema.SchemaReference;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import sf.util.Utility;

final class RoutineRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(RoutineRetriever.class.getName());

    RoutineRetriever(RetrieverConnection retrieverConnection, MutableDatabase database) throws SQLException {
        super(retrieverConnection, database);
    }

    void retrieveFunctionColumns(MutableFunction function, InclusionRule columnInclusionRule) throws SQLException {
        MetadataResultSet results = null;
        int ordinalNumber = 0;
        try {
            results = new MetadataResultSet(this.getMetaData().getFunctionColumns(this.unquotedName(function.getSchema().getCatalogName()), this.unquotedName(function.getSchema().getName()), this.unquotedName(function.getName()), null));
            while (results.next()) {
                String columnCatalogName = this.quotedName(results.getString("FUNCTION_CAT"));
                String schemaName = this.quotedName(results.getString("FUNCTION_SCHEM"));
                String functionName = this.quotedName(results.getString("FUNCTION_NAME"));
                String columnName = this.quotedName(results.getString("COLUMN_NAME"));
                String specificName = this.quotedName(results.getString("SPECIFIC_NAME"));
                MutableFunctionColumn column = new MutableFunctionColumn(function, columnName);
                String columnFullName = column.getFullName();
                if (!columnInclusionRule.include(columnFullName) || !function.getName().equals(functionName) || !this.belongsToSchema(function, columnCatalogName, schemaName) || !Utility.isBlank(specificName) && !specificName.equals(function.getSpecificName())) continue;
                LOGGER.log(Level.FINER, "Retrieving function column: " + columnName);
                short columnType = results.getShort("COLUMN_TYPE", (short)0);
                int dataType = results.getInt("DATA_TYPE", 0);
                String typeName = results.getString("TYPE_NAME");
                int length = results.getInt("LENGTH", 0);
                int precision = results.getInt("PRECISION", 0);
                boolean isNullable = results.getShort("NULLABLE", (short)2) == 1;
                String remarks = results.getString("REMARKS");
                column.setOrdinalPosition(ordinalNumber++);
                column.setFunctionColumnType(FunctionColumnType.valueOf(columnType));
                column.setType(this.lookupOrCreateColumnDataType(function.getSchema(), dataType, typeName));
                column.setSize(length);
                column.setPrecision(precision);
                column.setNullable(isNullable);
                column.setRemarks(remarks);
                column.addAttributes(results.getAttributes());
                function.addColumn(column);
            }
        }
        catch (AbstractMethodError e) {
            LOGGER.log(Level.WARNING, "JDBC driver does not support retrieving functions", e);
        }
        catch (SQLFeatureNotSupportedException e) {
            LOGGER.log(Level.WARNING, "JDBC driver does not support retrieving functions", e);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve columns for function " + function, e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveFunctions(String catalogName, String schemaName, InclusionRule routineInclusionRule) throws SQLException {
        if (routineInclusionRule == null || routineInclusionRule.equals(InclusionRule.EXCLUDE_ALL)) {
            return;
        }
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getFunctions(this.unquotedName(catalogName), this.unquotedName(schemaName), "%"));
            while (results.next()) {
                String functionName = this.quotedName(results.getString("FUNCTION_NAME"));
                LOGGER.log(Level.FINER, "Retrieving function: " + functionName);
                short functionType = results.getShort("FUNCTION_TYPE", (short)FunctionReturnType.unknown.getId());
                String remarks = results.getString("REMARKS");
                String specificName = results.getString("SPECIFIC_NAME");
                SchemaReference schema = new SchemaReference(catalogName, schemaName);
                MutableFunction function = new MutableFunction(schema, functionName);
                if (!routineInclusionRule.include(function.getFullName())) continue;
                function.setType(FunctionReturnType.valueOf(functionType));
                function.setSpecificName(specificName);
                function.setRemarks(remarks);
                function.addAttributes(results.getAttributes());
                this.database.addRoutine(function);
            }
        }
        catch (AbstractMethodError e) {
            LOGGER.log(Level.WARNING, "JDBC driver does not support retrieving functions", e);
        }
        catch (SQLFeatureNotSupportedException e) {
            LOGGER.log(Level.WARNING, "JDBC driver does not support retrieving functions", e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    void retrieveProcedureColumns(MutableProcedure procedure, InclusionRule columnInclusionRule) throws SQLException {
        MetadataResultSet results = null;
        int ordinalNumber = 0;
        try {
            results = new MetadataResultSet(this.getMetaData().getProcedureColumns(this.unquotedName(procedure.getSchema().getCatalogName()), this.unquotedName(procedure.getSchema().getName()), this.unquotedName(procedure.getName()), null));
            while (results.next()) {
                String columnCatalogName = this.quotedName(results.getString("PROCEDURE_CAT"));
                String schemaName = this.quotedName(results.getString("PROCEDURE_SCHEM"));
                String procedureName = this.quotedName(results.getString("PROCEDURE_NAME"));
                String columnName = this.quotedName(results.getString("COLUMN_NAME"));
                String specificName = this.quotedName(results.getString("SPECIFIC_NAME"));
                MutableProcedureColumn column = new MutableProcedureColumn(procedure, columnName);
                String columnFullName = column.getFullName();
                if (!columnInclusionRule.include(columnFullName) || !procedure.getName().equals(procedureName) || !this.belongsToSchema(procedure, columnCatalogName, schemaName) || !Utility.isBlank(specificName) && !specificName.equals(procedure.getSpecificName())) continue;
                LOGGER.log(Level.FINER, "Retrieving procedure column: " + columnName);
                short columnType = results.getShort("COLUMN_TYPE", (short)0);
                int dataType = results.getInt("DATA_TYPE", 0);
                String typeName = results.getString("TYPE_NAME");
                int length = results.getInt("LENGTH", 0);
                int precision = results.getInt("PRECISION", 0);
                boolean isNullable = results.getShort("NULLABLE", (short)2) == 1;
                String remarks = results.getString("REMARKS");
                column.setOrdinalPosition(ordinalNumber++);
                column.setProcedureColumnType(ProcedureColumnType.valueOf(columnType));
                column.setType(this.lookupOrCreateColumnDataType(procedure.getSchema(), dataType, typeName));
                column.setSize(length);
                column.setPrecision(precision);
                column.setNullable(isNullable);
                column.setRemarks(remarks);
                column.addAttributes(results.getAttributes());
                procedure.addColumn(column);
            }
        }
        catch (SQLException e) {
            throw new SchemaCrawlerSQLException("Could not retrieve columns for procedure " + procedure, e);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retrieveProcedures(String catalogName, String schemaName, InclusionRule routineInclusionRule) throws SQLException {
        if (routineInclusionRule == null || routineInclusionRule.equals(InclusionRule.EXCLUDE_ALL)) {
            return;
        }
        MetadataResultSet results = null;
        try {
            results = new MetadataResultSet(this.getMetaData().getProcedures(this.unquotedName(catalogName), this.unquotedName(schemaName), "%"));
            while (results.next()) {
                String procedureName = this.quotedName(results.getString("PROCEDURE_NAME"));
                LOGGER.log(Level.FINER, "Retrieving procedure: " + procedureName);
                short procedureType = results.getShort("PROCEDURE_TYPE", (short)ProcedureReturnType.unknown.getId());
                String remarks = results.getString("REMARKS");
                String specificName = results.getString("SPECIFIC_NAME");
                SchemaReference schema = new SchemaReference(catalogName, schemaName);
                MutableProcedure procedure = new MutableProcedure(schema, procedureName);
                if (!routineInclusionRule.include(procedure.getFullName())) continue;
                procedure.setType(ProcedureReturnType.valueOf(procedureType));
                procedure.setSpecificName(specificName);
                procedure.setRemarks(remarks);
                procedure.addAttributes(results.getAttributes());
                this.database.addRoutine(procedure);
            }
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }
}

