/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import schemacrawler.crawl.AbstractDatabaseObject;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineBodyType;
import schemacrawler.schema.Schema;
import sf.util.Utility;

abstract class MutableRoutine
extends AbstractDatabaseObject
implements Routine {
    private static final long serialVersionUID = 3906925686089134130L;
    private String specificName;
    private RoutineBodyType routineBodyType = RoutineBodyType.unknown;
    private final StringBuilder definition = new StringBuilder();

    MutableRoutine(Schema schema, String name) {
        super(schema, name);
    }

    @Override
    public String getDefinition() {
        return this.definition.toString();
    }

    @Override
    public String getLookupKey() {
        String lookupKey = super.getLookupKey();
        if (Utility.isBlank(this.specificName)) {
            return lookupKey;
        }
        return this.getSchema().getFullName() + "." + this.specificName;
    }

    @Override
    public RoutineBodyType getRoutineBodyType() {
        return this.routineBodyType;
    }

    @Override
    public String getSpecificName() {
        return this.specificName;
    }

    void appendDefinition(String definition) {
        if (definition != null) {
            this.definition.append(definition);
        }
    }

    void setRoutineBodyType(RoutineBodyType routineBodyType) {
        this.routineBodyType = routineBodyType;
    }

    void setSpecificName(String specificName) {
        this.specificName = specificName;
    }
}

