/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize.peephole;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.optimize.peephole.ClassMerger;

public class RetargetedInnerClassAttributeRemover
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor {
    private boolean retargeted;

    public void visitProgramClass(ProgramClass programClass) {
        int attributesCount = programClass.u2attributesCount;
        Object[] attributes = programClass.attributes;
        int newAtributesCount = 0;
        for (int index = 0; index < attributesCount; ++index) {
            Attribute attribute = attributes[index];
            this.retargeted = false;
            attribute.accept(programClass, this);
            if (this.retargeted) continue;
            attributes[newAtributesCount++] = attribute;
        }
        Arrays.fill(attributes, newAtributesCount, attributesCount, null);
        programClass.u2attributesCount = newAtributesCount;
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        this.checkTarget(clazz);
        if (!this.retargeted) {
            innerClassesAttribute.innerClassEntriesAccept(clazz, this);
            int classesCount = innerClassesAttribute.u2classesCount;
            Object[] classes = innerClassesAttribute.classes;
            int newClassesCount = 0;
            for (int index = 0; index < classesCount; ++index) {
                InnerClassesInfo classInfo = classes[index];
                this.retargeted = false;
                classInfo.outerClassConstantAccept(clazz, this);
                classInfo.innerClassConstantAccept(clazz, this);
                if (this.retargeted) continue;
                classes[newClassesCount++] = classInfo;
            }
            Arrays.fill(classes, newClassesCount, classesCount, null);
            innerClassesAttribute.u2classesCount = newClassesCount;
            this.retargeted = newClassesCount == 0;
        }
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        this.checkTarget(clazz);
        this.checkTarget(enclosingMethodAttribute.referencedClass);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        innerClassesInfo.innerClassConstantAccept(clazz, this);
        innerClassesInfo.outerClassConstantAccept(clazz, this);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.checkTarget(classConstant.referencedClass);
    }

    private void checkTarget(Clazz clazz) {
        if (clazz != null && ClassMerger.getTargetClass(clazz) != null) {
            this.retargeted = true;
        }
    }
}

