/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MemberObfuscator;
import proguard.util.ListUtil;

public class MappingKeeper
implements MappingProcessor {
    private final ClassPool classPool;
    private final WarningPrinter warningPrinter;
    private Clazz clazz;

    public MappingKeeper(ClassPool classPool, WarningPrinter warningPrinter) {
        this.classPool = classPool;
        this.warningPrinter = warningPrinter;
    }

    public boolean processClassMapping(String className, String newClassName) {
        String name = ClassUtil.internalClassName(className);
        this.clazz = this.classPool.getClass(name);
        if (this.clazz != null) {
            String currentNewName;
            String newName = ClassUtil.internalClassName(newClassName);
            if (this.warningPrinter != null && (currentNewName = ClassObfuscator.newClassName(this.clazz)) != null && !currentNewName.equals(newName)) {
                this.warningPrinter.print(name, currentNewName, "Warning: " + className + " is not being kept as '" + ClassUtil.externalClassName(currentNewName) + "', but remapped to '" + newClassName + "'");
            }
            ClassObfuscator.setNewClassName(this.clazz, newName);
            return true;
        }
        return false;
    }

    public void processFieldMapping(String className, String fieldType, String fieldName, String newClassName, String newFieldName) {
        String descriptor;
        String name;
        Field field;
        if (this.clazz != null && className.equals(newClassName) && (field = this.clazz.findField(name = fieldName, descriptor = ClassUtil.internalType(fieldType))) != null) {
            String currentNewName;
            if (this.warningPrinter != null && (currentNewName = MemberObfuscator.newMemberName(field)) != null && !currentNewName.equals(newFieldName)) {
                this.warningPrinter.print(ClassUtil.internalClassName(className), "Warning: " + className + ": field '" + fieldType + " " + fieldName + "' is not being kept as '" + currentNewName + "', but remapped to '" + newFieldName + "'");
            }
            MemberObfuscator.setFixedNewMemberName(field, newFieldName);
        }
    }

    public void processMethodMapping(String className, int firstLineNumber, int lastLineNumber, String methodReturnType, String methodName, String methodArguments, String newClassName, int newFirstLineNumber, int newLastLineNumber, String newMethodName) {
        String descriptor;
        Method method;
        if (this.clazz != null && className.equals(newClassName) && (method = this.clazz.findMethod(methodName, descriptor = ClassUtil.internalMethodDescriptor(methodReturnType, ListUtil.commaSeparatedList(methodArguments)))) != null) {
            String currentNewName;
            if (this.warningPrinter != null && (currentNewName = MemberObfuscator.newMemberName(method)) != null && !currentNewName.equals(newMethodName)) {
                this.warningPrinter.print(ClassUtil.internalClassName(className), "Warning: " + className + ": method '" + methodReturnType + " " + methodName + '(' + methodArguments + ')' + "' is not being kept as '" + currentNewName + "', but remapped to '" + newMethodName + "'");
            }
            MemberObfuscator.setFixedNewMemberName(method, newMethodName);
        }
    }
}

