/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.util.AllParameterVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ParameterVisitor;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.Stack;
import proguard.evaluation.Variables;
import proguard.evaluation.value.ReferenceValue;
import proguard.evaluation.value.Value;

public abstract class SimplifiedInvocationUnit
extends SimplifiedVisitor
implements InvocationUnit,
ParameterVisitor,
ConstantVisitor {
    private final MemberVisitor parameterInitializer = new AllParameterVisitor(true, this);
    private Variables variables;
    protected boolean isStatic;
    protected boolean isLoad;
    protected Stack stack;

    public void enterMethod(Clazz clazz, Method method, Variables variables) {
        int parameterSize = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
        variables.reset(parameterSize);
        this.variables = variables;
        method.accept(clazz, this.parameterInitializer);
        this.variables = null;
    }

    public void visitParameter(Clazz clazz, Member member, int parameterIndex, int parameterCount, int parameterOffset, int parameterSize, String parameterType, Clazz referencedClass) {
        Method method = (Method)member;
        Value value = this.getMethodParameterValue(clazz, method, parameterIndex, parameterType, referencedClass);
        this.variables.store(parameterOffset, value);
    }

    public void exitMethod(Clazz clazz, Method method, Value returnValue) {
        this.setMethodReturnValue(clazz, method, returnValue);
    }

    public void enterExceptionHandler(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, int catchType, Stack stack) {
        ClassConstant exceptionClassConstant = (ClassConstant)((ProgramClass)clazz).getConstant(catchType);
        stack.push(this.getExceptionValue(clazz, exceptionClassConstant));
    }

    public void invokeMember(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction, Stack stack) {
        int constantIndex = constantInstruction.constantIndex;
        switch (constantInstruction.opcode) {
            case -78: {
                this.isStatic = true;
                this.isLoad = true;
                break;
            }
            case -77: {
                this.isStatic = true;
                this.isLoad = false;
                break;
            }
            case -76: {
                this.isStatic = false;
                this.isLoad = true;
                break;
            }
            case -75: {
                this.isStatic = false;
                this.isLoad = false;
                break;
            }
            case -72: 
            case -70: {
                this.isStatic = true;
                break;
            }
            case -74: 
            case -73: 
            case -71: {
                this.isStatic = false;
            }
        }
        this.stack = stack;
        clazz.constantPoolEntryAccept(constantIndex, this);
        this.stack = null;
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        if (!this.isLoad) {
            this.setFieldValue(clazz, fieldrefConstant, this.stack.pop());
        }
        if (!this.isStatic) {
            this.setFieldClassValue(clazz, fieldrefConstant, this.stack.apop());
        }
        if (this.isLoad) {
            String type = fieldrefConstant.getType(clazz);
            this.stack.push(this.getFieldValue(clazz, fieldrefConstant, type));
        }
    }

    public void visitAnyMethodrefConstant(Clazz clazz, RefConstant methodrefConstant) {
        String type = methodrefConstant.getType(clazz);
        int parameterCount = ClassUtil.internalMethodParameterCount(type);
        if (!this.isStatic) {
            ++parameterCount;
        }
        for (int parameterIndex = parameterCount - 1; parameterIndex >= 0; --parameterIndex) {
            this.setMethodParameterValue(clazz, methodrefConstant, parameterIndex, this.stack.pop());
        }
        String returnType = ClassUtil.internalMethodReturnType(type);
        if (returnType.charAt(0) != 'V') {
            this.stack.push(this.getMethodReturnValue(clazz, methodrefConstant, returnType));
        }
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        String type = invokeDynamicConstant.getType(clazz);
        int parameterCount = ClassUtil.internalMethodParameterCount(type);
        if (!this.isStatic) {
            ++parameterCount;
        }
        for (int parameterIndex = parameterCount - 1; parameterIndex >= 0; --parameterIndex) {
            this.stack.pop();
        }
        String returnType = ClassUtil.internalMethodReturnType(type);
        if (returnType.charAt(0) != 'V') {
            this.stack.push(this.getMethodReturnValue(clazz, invokeDynamicConstant, returnType));
        }
    }

    public abstract Value getExceptionValue(Clazz var1, ClassConstant var2);

    public abstract void setFieldClassValue(Clazz var1, RefConstant var2, ReferenceValue var3);

    public abstract Value getFieldClassValue(Clazz var1, RefConstant var2, String var3);

    public abstract void setFieldValue(Clazz var1, RefConstant var2, Value var3);

    public abstract Value getFieldValue(Clazz var1, RefConstant var2, String var3);

    public abstract void setMethodParameterValue(Clazz var1, RefConstant var2, int var3, Value var4);

    public abstract Value getMethodParameterValue(Clazz var1, Method var2, int var3, String var4, Clazz var5);

    public abstract void setMethodReturnValue(Clazz var1, Method var2, Value var3);

    public abstract Value getMethodReturnValue(Clazz var1, RefConstant var2, String var3);

    public abstract Value getMethodReturnValue(Clazz var1, InvokeDynamicConstant var2, String var3);
}

