/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import java.io.PrintWriter;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class SimpleClassPrinter
implements ClassVisitor,
MemberVisitor {
    private final boolean printAccessModifiers;
    private final PrintWriter pw;

    public SimpleClassPrinter(boolean printAccessModifiers) {
        this(printAccessModifiers, new PrintWriter(System.out, true));
    }

    public SimpleClassPrinter(boolean printAccessModifiers, PrintWriter printWriter) {
        this.printAccessModifiers = printAccessModifiers;
        this.pw = printWriter;
    }

    public void visitProgramClass(ProgramClass programClass) {
        this.pw.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? programClass.getAccessFlags() : 0, programClass.getName()));
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        this.pw.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? libraryClass.getAccessFlags() : 0, libraryClass.getName()));
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.pw.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? programClass.getAccessFlags() : 0, programClass.getName()) + ": " + ClassUtil.externalFullFieldDescription(this.printAccessModifiers ? programField.getAccessFlags() : 0, programField.getName(programClass), programField.getDescriptor(programClass)));
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.pw.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? programClass.getAccessFlags() : 0, programClass.getName()) + ": " + ClassUtil.externalFullMethodDescription(programClass.getName(), this.printAccessModifiers ? programMethod.getAccessFlags() : 0, programMethod.getName(programClass), programMethod.getDescriptor(programClass)));
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.pw.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? libraryClass.getAccessFlags() : 0, libraryClass.getName()) + ": " + ClassUtil.externalFullFieldDescription(this.printAccessModifiers ? libraryField.getAccessFlags() : 0, libraryField.getName(libraryClass), libraryField.getDescriptor(libraryClass)));
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.pw.println(ClassUtil.externalFullClassDescription(this.printAccessModifiers ? libraryClass.getAccessFlags() : 0, libraryClass.getName()) + ": " + ClassUtil.externalFullMethodDescription(libraryClass.getName(), this.printAccessModifiers ? libraryMethod.getAccessFlags() : 0, libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass)));
    }
}

