/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.util.ArrayUtil;

public class MultiClassVisitor
implements ClassVisitor {
    private ClassVisitor[] classVisitors;
    private int classVisitorCount;

    public MultiClassVisitor() {
        this.classVisitors = new ClassVisitor[16];
    }

    public MultiClassVisitor(ClassVisitor ... classVisitors) {
        this.classVisitors = classVisitors;
        this.classVisitorCount = classVisitors.length;
    }

    public void addClassVisitor(ClassVisitor classVisitor) {
        this.classVisitors = ArrayUtil.add(this.classVisitors, this.classVisitorCount++, classVisitor);
    }

    public void visitProgramClass(ProgramClass programClass) {
        for (int index = 0; index < this.classVisitorCount; ++index) {
            this.classVisitors[index].visitProgramClass(programClass);
        }
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        for (int index = 0; index < this.classVisitorCount; ++index) {
            this.classVisitors[index].visitLibraryClass(libraryClass);
        }
    }
}

