/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.web.csskit.antlr;

import cz.vutbr.web.csskit.antlr.CSSLexerState;
import cz.vutbr.web.csskit.antlr.CSSToken;
import java.util.Stack;
import org.antlr.runtime.BitSet;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.NoViableAltException;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.RecognizerSharedState;
import org.antlr.runtime.Token;
import org.slf4j.Logger;

public class CSSTokenRecovery {
    private final Lexer lexer;
    private final CharStream input;
    private final RecognizerSharedState state;
    private final CSSLexerState ls;
    private final Logger log;
    private final Stack<Integer> expectedToken;
    public static final int APOS = 1;
    public static final int QUOT = 2;
    public static final int RPAREN = 3;
    public static final int RCURLY = 4;
    public static final int IMPORT = 5;
    public static final int CHARSET = 6;
    public static final int STRING = 7;
    public static final int INVALID_STRING = 8;
    private final CSSToken.TypeMapper typeMapper;

    public CSSTokenRecovery(Lexer lexer, CharStream input, RecognizerSharedState state, CSSLexerState ls, Logger log) {
        this.lexer = lexer;
        this.input = input;
        this.state = state;
        this.ls = ls;
        this.log = log;
        this.expectedToken = new Stack();
        this.typeMapper = new CSSToken.TypeMapper(CSSTokenRecovery.class, lexer.getClass(), "APOS", "QUOT", "RPAREN", "RCURLY", "IMPORT", "CHARSET", "STRING", "INVALID_STRING");
    }

    public void expecting(int token) {
        this.expectedToken.push(token);
    }

    public void end() {
        this.expectedToken.pop();
    }

    public boolean recover() {
        int t;
        if (this.expectedToken.isEmpty()) {
            return false;
        }
        try {
            t = this.typeMapper.inverse().get(this.expectedToken.pop());
        }
        catch (NullPointerException e) {
            return false;
        }
        switch (t) {
            case 5: 
            case 6: {
                BitSet charsetFollow = BitSet.of((int)125, (int)59);
                this.consumeUntilBalanced(charsetFollow);
                break;
            }
            case 7: {
                if (this.consumeAnyButEOF()) {
                    this.ls.quotOpen = false;
                    this.ls.aposOpen = false;
                    this.state.token = new CSSToken(this.typeMapper.get(8), this.ls, this.lexer.getClass());
                    this.state.token.setText("INVALID_STRING");
                    break;
                }
                char enclosing = this.ls.quotOpen ? (char)'\"' : '\'';
                this.ls.quotOpen = false;
                this.ls.aposOpen = false;
                this.state.token = new CSSToken(this.typeMapper.get(7), this.ls, this.state.tokenStartCharIndex, this.input.index() - 1, this.lexer.getClass());
                this.state.token.setText(this.input.substring(this.state.tokenStartCharIndex, this.input.index() - 1) + enclosing);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public Token nextToken() {
        while (true) {
            this.state.token = null;
            this.state.channel = 0;
            this.state.tokenStartCharIndex = this.input.index();
            this.state.tokenStartCharPositionInLine = this.input.getCharPositionInLine();
            this.state.tokenStartLine = this.input.getLine();
            this.state.text = null;
            if (this.input.LA(1) == -1) {
                if (!this.ls.isBalanced()) {
                    return this.generateEOFRecover();
                }
                return this.lexer.getEOFToken();
            }
            try {
                this.lexer.mTokens();
                if (this.state.token == null) {
                    this.lexer.emit();
                } else if (this.state.token == Token.SKIP_TOKEN) continue;
                return this.state.token;
            }
            catch (RecognitionException re) {
                this.lexer.reportError(re);
                if (re instanceof NoViableAltException) {
                    this.lexer.recover(re);
                }
                if (this.state.token != null) ** break;
                continue;
                this.state.token.setChannel(0);
                this.state.token.setInputStream(this.input);
                this.state.token.setLine(this.state.tokenStartLine);
                this.state.token.setCharPositionInLine(this.state.tokenStartCharPositionInLine);
                this.lexer.emit(this.state.token);
                return this.state.token;
            }
            break;
        }
    }

    public CSSToken generateEOFRecover() {
        CSSToken t = null;
        if (this.ls.aposOpen) {
            this.ls.aposOpen = false;
            t = new CSSToken(this.typeMapper.get(1), this.ls, this.lexer.getClass());
            t.setText("'");
        } else if (this.ls.quotOpen) {
            this.ls.quotOpen = false;
            t = new CSSToken(this.typeMapper.get(2), this.ls, this.lexer.getClass());
            t.setText("\"");
        } else if (this.ls.parenNest != 0) {
            this.ls.parenNest = (short)(this.ls.parenNest - 1);
            t = new CSSToken(this.typeMapper.get(3), this.ls, this.lexer.getClass());
            t.setText(")");
        } else if (this.ls.curlyNest != 0) {
            this.ls.curlyNest = (short)(this.ls.curlyNest - 1);
            t = new CSSToken(this.typeMapper.get(4), this.ls, this.lexer.getClass());
            t.setText("}");
        }
        this.log.debug("Recovering from EOF by {}", (Object)t);
        return t;
    }

    private void consumeUntilBalanced(BitSet follow) {
        int c;
        this.log.debug("Lexer entered consumeUntilBalanced with {} and follow {}", (Object)this.ls, (Object)follow);
        do {
            if ((c = this.input.LA(1)) == 39 && !this.ls.quotOpen) {
                this.ls.aposOpen = !this.ls.aposOpen;
            } else if (c == 34 && !this.ls.aposOpen) {
                this.ls.quotOpen = !this.ls.quotOpen;
            } else if (c == 40) {
                this.ls.parenNest = (short)(this.ls.parenNest + 1);
            } else if (c == 41 && this.ls.parenNest > 0) {
                this.ls.parenNest = (short)(this.ls.parenNest - 1);
            } else if (c == 123) {
                this.ls.curlyNest = (short)(this.ls.curlyNest + 1);
            } else if (c == 125 && this.ls.curlyNest > 0) {
                this.ls.curlyNest = (short)(this.ls.curlyNest - 1);
            } else if (c == 10) {
                if (this.ls.quotOpen) {
                    this.ls.quotOpen = false;
                } else if (this.ls.aposOpen) {
                    this.ls.aposOpen = false;
                }
            } else if (c == -1) {
                this.log.info("Unexpected EOF during consumeUntilBalanced, EOF not consumed");
                return;
            }
            this.input.consume();
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace("Lexer consumes '{}'({}) until balanced ({}).", new Object[]{Character.toString((char)c), Integer.toString(c), this.ls});
        } while (!this.ls.isBalanced() || !follow.member(c));
    }

    private boolean consumeAnyButEOF() {
        int c = this.input.LA(1);
        if (c == -1) {
            return false;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Lexer consumes '{}' while consumeButEOF", (Object)Character.toString((char)c));
        }
        this.input.consume();
        return true;
    }
}

