/*
 * Decompiled with CFR 0.152.
 */
package net.serenity.test.utils.rules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepListener;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class TestCase<T extends StepListener>
implements MethodRule {
    private List<T> listeners;
    private boolean finished;
    private String name;

    public TestCase(T ... listener) {
        this(UUID.randomUUID().toString(), (StepListener[])listener);
    }

    public TestCase(String name, T ... listener) {
        this.listeners = new ArrayList<T>(listener.length);
        this.register((StepListener[])listener);
        for (T regiter : listener) {
            this.listeners.add(regiter);
        }
        this.name = name;
    }

    public Collection<T> listeners() {
        return new ArrayList<T>(this.listeners);
    }

    public void register(T ... listener) {
        for (T regiter : listener) {
            this.listeners.add(regiter);
            StepEventBus.getEventBus().registerListener(regiter);
            regiter.testStarted(this.name);
        }
    }

    public T firstListener() {
        return (T)((StepListener)this.listeners.get(0));
    }

    public TestCase<T> finish() {
        if (!this.finished) {
            StepEventBus.getEventBus().testFinished();
            this.finished = true;
        }
        return this;
    }

    public String name() {
        return this.name;
    }

    public Statement apply(final Statement statement, FrameworkMethod frameworkMethod, Object o) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    for (StepListener regiter : TestCase.this.listeners) {
                        StepEventBus.getEventBus().registerListener(regiter);
                    }
                    StepEventBus.getEventBus().testStarted(TestCase.this.name);
                    statement.evaluate();
                }
                finally {
                    TestCase.this.finish();
                }
            }
        };
    }
}

