/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import java.util.Arrays;
import java.util.stream.Collectors;
import net.serenitybdd.core.strings.FirstLine;

public class CustomFieldValue {
    private String name;
    private String text;
    private String renderedText;

    public CustomFieldValue() {
    }

    public CustomFieldValue(String name, String text) {
        this.name = name;
        this.text = text;
        this.renderedText = null;
    }

    public CustomFieldValue(String name, String text, String renderedText) {
        this.name = name;
        this.text = text;
        this.renderedText = renderedText;
    }

    public String getName() {
        return this.name;
    }

    public String getText() {
        return this.text;
    }

    public String getRenderedText() {
        return this.renderedText != null ? this.withLineBreaks(this.renderedText) : this.withLineBreaks(this.text);
    }

    public String getRenderedTextWithoutTables() {
        String fullText = this.renderedText != null ? this.withLineBreaks(this.renderedText) : this.withLineBreaks(this.text);
        return fullText.replaceAll("\\{example-result.*\\}", "");
    }

    private String withLineBreaks(String text) {
        return Arrays.asList(text.split("\\r?\\n")).stream().map(line -> line + "  ").collect(Collectors.joining(System.lineSeparator()));
    }

    public String getRenderedSummary() {
        String rawText = this.renderedText != null ? this.renderedText : this.text;
        return FirstLine.of(rawText);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", text='").append(this.text).append('\'');
        sb.append(", renderedText='").append(this.renderedText).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

