/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.core.collect.NewList;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.files.TheDirectoryStructure;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.AbstractRequirementsTagProvider;
import net.thucydides.core.requirements.AllRequirements;
import net.thucydides.core.requirements.OverridableTagProvider;
import net.thucydides.core.requirements.RequirementAncestry;
import net.thucydides.core.requirements.RequirementsPath;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.RootDirectory;
import net.thucydides.core.requirements.model.FeatureType;
import net.thucydides.core.requirements.model.NarrativeReader;
import net.thucydides.core.requirements.model.OverviewReader;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.RequirementDefinition;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.requirements.model.cucumber.CucumberParser;
import net.thucydides.core.requirements.model.cucumber.InvalidFeatureFileException;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRequirementsTagProvider
extends AbstractRequirementsTagProvider
implements RequirementsTagProvider,
OverridableTagProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemRequirementsTagProvider.class);
    private static final List<Requirement> NO_REQUIREMENTS = new ArrayList<Requirement>();
    private static final List<TestTag> NO_TEST_TAGS = new ArrayList<TestTag>();
    private static final String STORY_EXTENSION = "story";
    private static final String FEATURE_EXTENSION = "feature";
    private final NarrativeReader narrativeReader;
    private final OverviewReader overviewReader;
    private final Set<String> directoryPaths;
    private final int level;
    private final List<String> requirementTypes;
    private static final String DEFAULT_FEATURE_DIRECTORY = "src/test/resources/features";
    private final RequirementsConfiguration requirementsConfiguration;
    private volatile List<Requirement> requirements;
    private int maxDepth;
    private final String topLevelDirectory;
    private Set<String> requirementsDirectoryPaths;
    private final Object requirementsLock = new Object();
    private final Set<File> invalidFeatureFiles = new HashSet<File>();

    public FileSystemRequirementsTagProvider(EnvironmentVariables environmentVariables) {
        this(environmentVariables, RootDirectory.definedIn(environmentVariables).featuresOrStoriesRootDirectory().orElse(Paths.get(DEFAULT_FEATURE_DIRECTORY, new String[0])).toString());
    }

    public FileSystemRequirementsTagProvider(EnvironmentVariables environmentVariables, String rootDirectoryPath) {
        this(rootDirectoryPath, environmentVariables);
    }

    public FileSystemRequirementsTagProvider() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, int level) {
        this(FileSystemRequirementsTagProvider.filePathFormOf(rootDirectory), level, SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    private String baseDirectory() {
        if (this.level == 0) {
            return this.rootDirectory;
        }
        Path baseDirectory = Paths.get(this.rootDirectory, new String[0]);
        for (int step = 0; step < this.level; ++step) {
            if (baseDirectory.getParent() == null) continue;
            baseDirectory = baseDirectory.getParent();
        }
        return baseDirectory.toString();
    }

    private static String filePathFormOf(String rootDirectory) {
        if (rootDirectory.contains(".")) {
            return rootDirectory.replace(".", "/");
        }
        return rootDirectory;
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, EnvironmentVariables environmentVariables) {
        super(environmentVariables, rootDirectory);
        this.topLevelDirectory = rootDirectory;
        this.requirementTypes = new RequirementsConfiguration(environmentVariables, rootDirectory).getRequirementTypes();
        this.narrativeReader = NarrativeReader.forRootDirectory(environmentVariables, rootDirectory);
        this.overviewReader = new OverviewReader();
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
        this.directoryPaths = FileSystemRequirementsTagProvider.rootDirectories(rootDirectory, environmentVariables);
        this.level = this.requirementsConfiguration.startLevelForADepthOf(this.maxDirectoryDepthIn(this.directoryPaths) + 1);
        this.maxDepth = this.maxDirectoryDepthIn(this.directoryPaths);
        this.requirementsDirectoryPaths = RootDirectory.definedIn(environmentVariables).requirementsDirectoryNames();
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, int level, EnvironmentVariables environmentVariables) {
        this(rootDirectory, rootDirectory, level, environmentVariables);
    }

    public FileSystemRequirementsTagProvider(String topLevelDirectory, String rootDirectory, int level, EnvironmentVariables environmentVariables) {
        super(environmentVariables, rootDirectory);
        this.topLevelDirectory = topLevelDirectory;
        this.requirementTypes = new RequirementsConfiguration(environmentVariables, rootDirectory).getRequirementTypes();
        this.narrativeReader = NarrativeReader.forRootDirectory(environmentVariables, rootDirectory);
        this.overviewReader = new OverviewReader();
        this.directoryPaths = FileSystemRequirementsTagProvider.rootDirectories(rootDirectory, environmentVariables);
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
        this.level = level;
        this.maxDepth = this.maxDirectoryDepthIn(this.directoryPaths);
    }

    private static Set<String> rootDirectories(String rootDirectory, EnvironmentVariables environmentVariables) {
        return new RootDirectory(environmentVariables, rootDirectory).getRootDirectoryPaths();
    }

    public FileSystemRequirementsTagProvider(String rootDirectory) {
        this(FileSystemRequirementsTagProvider.filePathFormOf(rootDirectory), SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            Object object = this.requirementsLock;
            synchronized (object) {
                if (this.requirements == null) {
                    this.requirements = this.getRootDirectoryPaths().stream().map(this::capabilitiesAndStoriesIn).flatMap(Collection::stream).sorted().collect(Collectors.toList());
                    this.requirements = RequirementAncestry.addParentsTo(this.requirements);
                }
            }
        }
        return this.requirements;
    }

    private Set<Requirement> capabilitiesAndStoriesIn(String path) {
        HashSet<Requirement> allRequirements = new HashSet<Requirement>();
        File rootDirectory = new File(path);
        if (rootDirectory.exists()) {
            this.loadCapabilitiesFrom(rootDirectory.listFiles(this.thatAreFeatureDirectories())).forEach(capability -> allRequirements.add((Requirement)capability));
            this.loadStoriesFrom(rootDirectory.listFiles(this.thatAreStories())).forEach(leafRequirement -> allRequirements.add((Requirement)leafRequirement));
        }
        return allRequirements;
    }

    private int maxDirectoryDepthIn(Set<String> directoryPaths) {
        return directoryPaths.stream().mapToInt(directoryPath -> TheDirectoryStructure.startingAt(new File((String)directoryPath)).maxDepth()).max().orElse(0);
    }

    public Set<String> getRootDirectoryPaths() {
        return new RootDirectory(this.environmentVariables, this.rootDirectory).getRootDirectoryPaths();
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet<TestTag> tags = new HashSet<TestTag>();
        if (testOutcome.getPath() != null) {
            Optional<TestTag> matchingRequirementTag;
            Optional<Requirement> matchingRequirement = this.requirementWithMatchingFeatureFile(testOutcome);
            matchingRequirement.ifPresent(requirement -> {
                tags.add(requirement.asTag());
                tags.addAll(this.parentRequirementsOf(requirement.asTag()));
            });
            List<String> storyPathElements = this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath())));
            tags.addAll(this.getMatchingCapabilities(this.getRequirements(), this.stripStorySuffixFrom(storyPathElements)));
            if (tags.isEmpty() && this.storyOrFeatureDescribedIn(storyPathElements).isPresent() && (matchingRequirementTag = this.getMatchingRequirementTagsFor(this.storyOrFeatureDescribedIn(storyPathElements).get())).isPresent()) {
                tags.add(matchingRequirementTag.get());
                tags.addAll(this.parentRequirementsOf(matchingRequirementTag.get()));
            }
        }
        return tags;
    }

    Optional<Requirement> requirementWithMatchingFeatureFile(TestOutcome testOutcome) {
        String candidatePath = testOutcome.getPath();
        String parentRequirementId = testOutcome.getParentId();
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.getId() != null && requirement.getId().equals(parentRequirementId) || requirement.getFeatureFileName() != null && requirement.getFeatureFileName().equalsIgnoreCase(candidatePath) || requirement.getPath() != null && this.equivalentPaths(requirement.getPath(), candidatePath)).findFirst();
    }

    private Collection<TestTag> parentRequirementsOf(TestTag requirementTag) {
        ArrayList<TestTag> matchingTags = new ArrayList<TestTag>();
        Optional<Requirement> matchingRequirement = this.getMatchingRequirementFor(requirementTag);
        Optional<Requirement> parent = this.parentRequirementsOf(matchingRequirement.get());
        while (parent.isPresent()) {
            matchingTags.add(parent.get().asTag());
            parent = this.parentRequirementsOf(parent.get());
        }
        return matchingTags;
    }

    private Optional<Requirement> parentRequirementsOf(Requirement matchingRequirement) {
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.getChildren().contains(matchingRequirement)).findFirst();
    }

    private List<String> stripStorySuffixFrom(List<String> pathElements) {
        if (!pathElements.isEmpty() && this.isSupportedFileStoryExtension(this.last(pathElements))) {
            return this.dropLastElement(pathElements);
        }
        return pathElements;
    }

    private List<String> dropLastElement(List<String> pathElements) {
        ArrayList<String> strippedPathElements = new ArrayList<String>(pathElements);
        strippedPathElements.remove(pathElements.size() - 1);
        return strippedPathElements;
    }

    private Optional<Requirement> getMatchingRequirementFor(TestTag storyOrFeatureTag) {
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.asTag().isAsOrMoreSpecificThan(storyOrFeatureTag)).findFirst();
    }

    private Optional<TestTag> getMatchingRequirementTagsFor(TestTag storyOrFeatureTag) {
        Optional<Requirement> matchingRequirement = this.getMatchingRequirementFor(storyOrFeatureTag);
        return matchingRequirement.map(Requirement::asTag);
    }

    private Optional<TestTag> storyOrFeatureDescribedIn(List<String> storyPathElements) {
        if (!storyPathElements.isEmpty() && this.isSupportedFileStoryExtension(this.last(storyPathElements))) {
            String storyName = NewList.reverse(storyPathElements).get(1);
            String storyParent = this.parentElement(storyPathElements);
            String qualifiedName = storyParent == null ? NameConverter.humanize(storyName) : NameConverter.humanize(storyParent).trim() + "/" + NameConverter.humanize(storyName);
            TestTag storyTag = TestTag.withName(qualifiedName).andType(this.last(storyPathElements));
            return Optional.of(storyTag);
        }
        return Optional.empty();
    }

    private String parentElement(List<String> storyPathElements) {
        return storyPathElements.size() > 2 ? NewList.reverse(storyPathElements).get(2) : null;
    }

    private String last(List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        return this.firstRequirementFoundIn(this.parentRequirementFromPackagePath(testOutcome), this.requirementWithMatchingParentId(testOutcome), this.requirementWithMatchingPath(testOutcome), this.featureTagRequirementIn(testOutcome), this.mostSpecificTagRequirementFor(testOutcome));
    }

    private Optional<Requirement> featureTagRequirementIn(TestOutcome testOutcome) {
        List<String> storyPathElements = this.stripStorySuffixFrom(this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath()))));
        return this.lastRequirementFrom(storyPathElements);
    }

    private Optional<Requirement> parentRequirementFromPackagePath(TestOutcome testOutcome) {
        if (testOutcome.getPath() != null) {
            List<String> storyPathElements = this.stripStorySuffixFrom(this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath()))));
            return this.lastRequirementFrom(storyPathElements);
        }
        return Optional.empty();
    }

    private Optional<Requirement> mostSpecificTagRequirementFor(TestOutcome testOutcome) {
        Optional<Requirement> mostSpecificRequirement = Optional.empty();
        int currentSpecificity = -1;
        for (TestTag tag : testOutcome.getTags()) {
            int specificity;
            Optional<Requirement> matchingRequirement = this.getRequirementFor(tag);
            if (!matchingRequirement.isPresent() || currentSpecificity >= (specificity = this.requirementsConfiguration.getRequirementTypes().indexOf(matchingRequirement.get().getType()))) continue;
            currentSpecificity = specificity;
            mostSpecificRequirement = matchingRequirement;
        }
        return mostSpecificRequirement;
    }

    private Optional<Requirement> requirementWithMatchingPath(TestOutcome testOutcome) {
        Path testOutcomeRequirementsPath = RootDirectory.definedIn(this.environmentVariables).getRelativePathOf(testOutcome.getPath());
        Optional<Requirement> requirementWithMatchingPath = AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> this.requirementHasPathMatching((Requirement)requirement, testOutcomeRequirementsPath)).findFirst();
        Optional<Requirement> requirementWithAMatchingName = AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> this.requirementHasNameMatching((Requirement)requirement, testOutcomeRequirementsPath)).findFirst();
        if (requirementWithMatchingPath.isPresent()) {
            return requirementWithMatchingPath;
        }
        if (requirementWithAMatchingName.isPresent()) {
            return requirementWithAMatchingName;
        }
        if (testOutcome.getPath() == null) {
            return Optional.empty();
        }
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.getPath() != null).filter(requirement -> this.equivalentPaths(requirement.getPath(), testOutcome.getPath())).findFirst();
    }

    private boolean requirementHasPathMatching(Requirement requirement, Path expectedPath) {
        return requirement.getPath() != null && expectedPath.equals(Paths.get(requirement.getPath(), new String[0]));
    }

    private boolean requirementHasNameMatching(Requirement requirement, Path expectedPath) {
        return requirement.getFeatureFileName() != null && expectedPath.equals(Paths.get(requirement.getFeatureFileName(), new String[0]));
    }

    private boolean equivalentPaths(String pathA, String pathB) {
        String normalisedPathA = this.removeFeatureOrStoryPrefixFrom(pathA.replaceAll("[/\\\\]", "/")).replaceAll("\\.", "/").replaceAll(" ", "_");
        String normalisedPathB = this.removeFeatureOrStoryPrefixFrom(pathB.replaceAll("[/\\\\]", "/")).replaceAll("\\.", "/").replaceAll(" ", "_");
        return normalisedPathA.equalsIgnoreCase(normalisedPathB);
    }

    private String removeFeatureOrStoryPrefixFrom(String path) {
        String stories = RootDirectory.definedIn(this.environmentVariables).storyDirectoryName();
        String features = RootDirectory.definedIn(this.environmentVariables).featureDirectoryName();
        if (path.startsWith(stories)) {
            path = path.substring(stories.length() + 1);
        }
        if (path.startsWith(features)) {
            path = path.substring(stories.length() + 1);
        }
        if (path.endsWith(".story")) {
            path = path.substring(0, path.length() - 6);
        }
        if (path.endsWith(".feature")) {
            path = path.substring(0, path.length() - 8);
        }
        return path;
    }

    private Optional<Requirement> requirementWithMatchingParentId(TestOutcome testOutcome) {
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.getId() != null && testOutcome.getParentId() != null && requirement.getId().equals(testOutcome.getParentId())).findFirst();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.getName().equalsIgnoreCase(testTag.getName()) && requirement.getType().equalsIgnoreCase(testTag.getType())).findFirst();
    }

    private Optional<Requirement> lastRequirementFrom(List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return Optional.empty();
        }
        return this.lastRequirementMatchingPath(this.getRequirements(), storyPathElements);
    }

    private Optional<Requirement> lastRequirementMatchingPath(List<Requirement> requirements, List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return Optional.empty();
        }
        Optional<Requirement> matchingRequirement = this.findMatchingRequirementIn(this.next(storyPathElements), requirements);
        if (!matchingRequirement.isPresent()) {
            return Optional.empty();
        }
        if (this.tail(storyPathElements).isEmpty()) {
            return matchingRequirement;
        }
        List<Requirement> childRequrements = matchingRequirement.get().getChildren();
        return this.lastRequirementMatchingPath(childRequrements, this.tail(storyPathElements));
    }

    private List<TestTag> getMatchingCapabilities(List<Requirement> requirements, List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return NO_TEST_TAGS;
        }
        Optional<Requirement> matchingRequirement = this.findMatchingRequirementIn(this.next(storyPathElements), requirements);
        if (matchingRequirement.isPresent()) {
            TestTag thisTag = matchingRequirement.get().asTag();
            List<TestTag> remainingTags = this.getMatchingCapabilities(matchingRequirement.get().getChildren(), this.tail(storyPathElements));
            return this.concat(thisTag, remainingTags);
        }
        return NO_TEST_TAGS;
    }

    private List<String> stripRootFrom(List<String> storyPathElements) {
        return RequirementsPath.stripRootFromPath(this.rootDirectory, storyPathElements);
    }

    private String stripRootPathFrom(String testOutcomePath) {
        if (testOutcomePath == null) {
            return "";
        }
        String rootPath = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)rootPath) && testOutcomePath.startsWith(rootPath) && !testOutcomePath.equals(rootPath)) {
            return testOutcomePath.substring(rootPath.length() + 1);
        }
        return testOutcomePath;
    }

    private List<TestTag> concat(TestTag thisTag, List<TestTag> remainingTags) {
        ArrayList<TestTag> totalTags = new ArrayList<TestTag>();
        totalTags.add(thisTag);
        totalTags.addAll(remainingTags);
        return totalTags;
    }

    private <T> T next(List<T> elements) {
        return elements.get(0);
    }

    private <T> List<T> tail(List<T> elements) {
        return elements.subList(1, elements.size());
    }

    private Optional<Requirement> findMatchingRequirementIn(String storyPathElement, List<Requirement> requirements) {
        for (Requirement requirement : requirements) {
            String normalizedStoryPathElement = Inflector.getInstance().humanize(Inflector.getInstance().underscore(storyPathElement, new char[0]), new String[0]);
            if (!requirement.getName().equals(normalizedStoryPathElement) && !storyPathElement.equalsIgnoreCase(FilenameUtils.removeExtension((String)requirement.getFeatureFileName())) && !storyPathElement.equalsIgnoreCase(requirement.getName())) continue;
            return Optional.of(requirement);
        }
        return Optional.empty();
    }

    private Stream<Requirement> loadCapabilitiesFrom(File[] requirementDirectories) {
        return Arrays.stream(requirementDirectories).map(this::readRequirementFrom);
    }

    private Stream<Requirement> loadStoriesFrom(File[] storyFiles) {
        return Arrays.stream(storyFiles).map(this::readRequirementsFromStoryOrFeatureFile).filter(Optional::isPresent).map(Optional::get);
    }

    public Requirement readRequirementFrom(File requirementDirectory) {
        Optional<RequirementDefinition> requirementNarrative = this.narrativeReader.loadFrom(requirementDirectory, Math.max(0, this.level - 1));
        if (requirementNarrative.isPresent()) {
            return this.requirementWithNarrative(requirementDirectory, this.humanReadableVersionOf(requirementDirectory.getName()), requirementNarrative.get());
        }
        return this.requirementFromDirectoryName(requirementDirectory);
    }

    public Optional<Requirement> readRequirementsFromStoryOrFeatureFile(File storyFile) {
        if (this.invalidFeatureFiles.contains(storyFile)) {
            return Optional.empty();
        }
        FeatureType type = this.featureTypeOf(storyFile);
        try {
            Requirement requirement;
            Optional<RequirementDefinition> narrative = type == FeatureType.STORY ? this.loadFromStoryFile(storyFile) : this.loadFromFeatureFile(storyFile);
            String storyName = this.storyNameFrom(narrative, type, storyFile);
            if (narrative.isPresent()) {
                requirement = this.leafRequirementWithNarrative(storyName, storyFile.getPath(), narrative.get()).withType(type.toString());
                if (narrative.get().background().isPresent()) {
                    requirement = requirement.withBackground(narrative.get().background().get());
                }
                if (narrative.get().getScenarios().isEmpty()) {
                    requirement = requirement.withNoScenarios();
                }
            } else {
                requirement = this.storyNamed(storyName, storyFile.getPath()).withType(type.toString());
            }
            return Optional.of(requirement.definedInFile(storyFile));
        }
        catch (InvalidFeatureFileException invalidFeatureFile) {
            this.invalidFeatureFiles.add(storyFile);
            return Optional.empty();
        }
    }

    private String storyNameFrom(Optional<RequirementDefinition> narrative, FeatureType type, File storyFile) {
        if (narrative.isPresent() && StringUtils.isNotBlank((CharSequence)narrative.get().getTitle().orElse(""))) {
            return narrative.get().getTitle().get();
        }
        if (this.isSnakeCase(storyFile.getName())) {
            return storyFile.getName().replace(type.getExtension(), "").replace("_", " ");
        }
        String storyNameWithoutExtension = storyFile.getName().replace(type.getExtension(), "");
        String snakeCaseStoryName = Inflector.inflection().underscore(storyNameWithoutExtension, new char[0]);
        return Inflector.inflection().of(snakeCaseStoryName).asATitle().toString();
    }

    private boolean isSnakeCase(String name) {
        return name.contains("_");
    }

    private Optional<RequirementDefinition> loadFromStoryFile(File storyFile) {
        return this.narrativeReader.loadFromStoryFile(storyFile);
    }

    private Optional<RequirementDefinition> loadFromFeatureFile(File storyFile) {
        String explicitLocale = this.readLocaleFromFeatureFile(storyFile);
        CucumberParser parser = explicitLocale != null ? new CucumberParser(explicitLocale, this.environmentVariables) : new CucumberParser(this.environmentVariables);
        return parser.loadFeatureDefinition(storyFile);
    }

    private String readLocaleFromFeatureFile(File storyFile) {
        try {
            List featureFileLines = FileUtils.readLines((File)storyFile, (Charset)Charset.defaultCharset());
            for (String line : featureFileLines) {
                if (!line.startsWith("#") || !line.contains("language:")) continue;
                return line.substring(line.indexOf("language:") + 10).trim();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private FeatureType featureTypeOf(File storyFile) {
        return storyFile.getName().endsWith(".story") ? FeatureType.STORY : FeatureType.FEATURE;
    }

    private Requirement requirementFromDirectoryName(File requirementDirectory) {
        String requirementType = this.getRequirementTypeOf(requirementDirectory);
        String shortName = this.humanReadableVersionOf(requirementDirectory.getName());
        List<Requirement> children = this.readChildrenFrom(requirementDirectory);
        return Requirement.named(shortName).withType(requirementType).withNarrative("").withPath(this.relativeDirectoryOf(requirementDirectory.getPath())).withChildren(children);
    }

    private String getRequirementTypeOf(File requirementDirectory) {
        int depth = this.requirementDepthOf(this.topLevelDirectory, requirementDirectory);
        int maxDepth = TheDirectoryStructure.startingAt(this.directoryAt(this.topLevelDirectory)).maxDepth();
        return this.getDefaultType(depth, maxDepth);
    }

    private File directoryAt(String path) {
        try {
            if (this.getClass().getClassLoader().getResource(path) != null) {
                return new File(this.getClass().getClassLoader().getResource(path).toURI());
            }
            return new File(path);
        }
        catch (URISyntaxException invalidRootDirectory) {
            throw new SerenityManagedException(invalidRootDirectory);
        }
    }

    private int requirementDepthOf(String rootDirectory, File requirementDirectory) {
        if (rootDirectory.equals(requirementDirectory.getPath())) {
            return 0;
        }
        String normalizedRequirementsPath = requirementDirectory.getPath().replace("\\", "/");
        String normalizedRootDirectory = rootDirectory.replace("\\", "/");
        String relativePath = normalizedRequirementsPath.substring(normalizedRequirementsPath.indexOf(normalizedRootDirectory) + normalizedRootDirectory.length() + 1);
        return relativePath.split("\\/|\\\\").length - 1;
    }

    private String relativeDirectoryOf(String path) {
        String baseDirectory = this.baseDirectory();
        if (path.contains(baseDirectory)) {
            int relativePathStartsAt = path.indexOf(baseDirectory) + baseDirectory.length() + 1;
            return relativePathStartsAt < path.length() ? path.substring(relativePathStartsAt) : "";
        }
        return path;
    }

    private Requirement storyNamed(String storyName, String path) {
        String shortName = this.humanReadableVersionOf(storyName);
        return Requirement.named(shortName).withType(STORY_EXTENSION).withNarrative(shortName).withPath(this.relativeDirectoryOf(path));
    }

    private Requirement leafRequirementWithNarrative(String shortName, String path, RequirementDefinition requirementNarrative) {
        String displayName = this.getTitleFromNarrativeOrDirectoryName(requirementNarrative, shortName);
        String cardNumber = requirementNarrative.getCardNumber().orElse(null);
        String type = requirementNarrative.getType();
        List<String> releaseVersions = requirementNarrative.getVersionNumbers();
        return Requirement.named(shortName).withId(requirementNarrative.getId().orElse(path)).withOptionalDisplayName(displayName).withOptionalCardNumber(cardNumber).withType(type).withNarrative(requirementNarrative.getText()).withPath(this.relativeDirectoryOf(path)).withReleaseVersions(releaseVersions).withTags(requirementNarrative.getTags()).withScenarioTags(requirementNarrative.getScenarioTags());
    }

    private Requirement requirementWithNarrative(File requirementDirectory, String shortName, RequirementDefinition requirementNarrative) {
        String displayName = this.getTitleFromNarrativeOrDirectoryName(requirementNarrative, shortName);
        String cardNumber = requirementNarrative.getCardNumber().orElse(null);
        String type = requirementNarrative.getType();
        List<String> releaseVersions = requirementNarrative.getVersionNumbers();
        List<Requirement> children = this.readChildrenFrom(requirementDirectory);
        return Requirement.named(shortName).withOptionalDisplayName(displayName).withOptionalCardNumber(cardNumber).withType(type).withNarrative(requirementNarrative.getText()).withReleaseVersions(releaseVersions).withPath(this.relativeDirectoryOf(requirementDirectory.getPath())).withChildren(children);
    }

    private List<Requirement> readChildrenFrom(File requirementDirectory) {
        String childDirectory = this.rootDirectory + "/" + requirementDirectory.getName();
        if (this.childrenExistFor(childDirectory)) {
            FileSystemRequirementsTagProvider childReader = new FileSystemRequirementsTagProvider(this.rootDirectory, childDirectory, this.level + 1, this.environmentVariables);
            return childReader.getRequirements();
        }
        if (this.childrenExistFor(requirementDirectory.getPath())) {
            FileSystemRequirementsTagProvider childReader = new FileSystemRequirementsTagProvider(this.rootDirectory, requirementDirectory.getPath(), this.level + 1, this.environmentVariables);
            return childReader.getRequirements();
        }
        return NO_REQUIREMENTS;
    }

    private boolean childrenExistFor(String path) {
        if (this.hasSubdirectories(path)) {
            return true;
        }
        if (this.hasFeatureOrStoryFiles(path)) {
            return true;
        }
        return this.classpathResourceExistsFor(path);
    }

    private boolean hasFeatureOrStoryFiles(String path) {
        File requirementDirectory = new File(path);
        if (requirementDirectory.isDirectory()) {
            return requirementDirectory.list(this.storyFiles()).length > 0 || requirementDirectory.list(this.featureFiles()).length > 0;
        }
        return false;
    }

    private FilenameFilter storyFiles() {
        return (dir, name) -> name.endsWith(".story");
    }

    private FilenameFilter featureFiles() {
        return (dir, name) -> name.endsWith(".feature");
    }

    private boolean classpathResourceExistsFor(String path) {
        return this.getClass().getResource(this.resourcePathFor(path)) != null;
    }

    private String resourcePathFor(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }

    private boolean hasSubdirectories(String path) {
        File pathDirectory = new File(path);
        if (!pathDirectory.exists()) {
            return false;
        }
        for (File subdirectory : pathDirectory.listFiles()) {
            if (!subdirectory.isDirectory()) continue;
            return true;
        }
        return false;
    }

    private String getTitleFromNarrativeOrDirectoryName(RequirementDefinition requirementNarrative, String nameIfNoNarrativePresent) {
        if (requirementNarrative.getTitle().isPresent() && StringUtils.isNotBlank((CharSequence)requirementNarrative.getTitle().get())) {
            return requirementNarrative.getTitle().get();
        }
        return nameIfNoNarrativePresent;
    }

    private FileFilter thatAreFeatureDirectories() {
        return file -> !file.getName().startsWith(".") && this.storyOrFeatureFilesExistIn(file);
    }

    private boolean storyOrFeatureFilesExistIn(File directory) {
        return TheDirectoryStructure.startingAt(directory).containsFiles(this.thatAreStories(), this.thatAreNarratives());
    }

    private FileFilter thatAreStories() {
        return file -> {
            String filename = file.getName().toLowerCase();
            if (filename.startsWith("given") || filename.startsWith("precondition")) {
                return false;
            }
            return file.getName().toLowerCase().endsWith(".story") || file.getName().toLowerCase().endsWith(".feature");
        };
    }

    private FileFilter thatAreNarratives() {
        return file -> file.getName().equalsIgnoreCase("narrative.txt") || file.getName().equalsIgnoreCase("narrative.md") || file.getName().equalsIgnoreCase("readme.md") || file.getName().equalsIgnoreCase("placeholder.txt");
    }

    private boolean isSupportedFileStoryExtension(String storyFileExtension) {
        return storyFileExtension.equalsIgnoreCase(FEATURE_EXTENSION) || storyFileExtension.equalsIgnoreCase(STORY_EXTENSION);
    }

    @Override
    public Optional<String> getOverview() {
        return this.overviewReader.readOverviewFrom(this.directoryPaths.toArray(new String[0]));
    }
}

